/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonFrame;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.floodgate.FloodgateTextures;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateChameleonPresetForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Player player;

    public FloodgateChameleonPresetForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.player = this.plugin.getServer().getPlayer(this.uuid);
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Chameleon Circuit");
        for (ChameleonPreset preset : ChameleonPreset.values()) {
            if (!preset.isBlockPreset() || !TARDISPermission.hasPermission(this.player, "tardis.preset." + preset.toString().toLowerCase(Locale.ROOT))) continue;
            String path = String.format("textures/%s.png", FloodgateTextures.lookup.get(preset.getGuiDisplay().toString()));
            builder.button(preset.toString(), FormImage.Type.PATH, path);
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        String label = response.clickedButton().text();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", this.uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("tardis_id", id);
                wherec.put("type", Control.CHAMELEON.getId());
                ResultSetControls rsc = new ResultSetControls(this.plugin, wherec, true);
                boolean hasSign = rsc.resultSet();
                HashMap<String, Object> wheref = new HashMap<String, Object>();
                wheref.put("tardis_id", id);
                wheref.put("type", Control.FRAME.getId());
                ResultSetControls rsf = new ResultSetControls(this.plugin, wheref, true);
                boolean hasFrame = rsf.resultSet();
                HashMap<String, Object> set = new HashMap<String, Object>();
                ChameleonPreset selected = ChameleonPreset.valueOf(label);
                set.put("chameleon_preset", selected.toString());
                if (hasSign) {
                    this.updateChameleonSign(rsf.getData(), selected.toString(), this.player);
                }
                if (hasFrame) {
                    new ChameleonFrame().updateChameleonFrame(selected, rsf.getLocation());
                }
                this.plugin.getMessenger().sendInsertedColour((CommandSender)this.player, "CHAM_SET", selected.getDisplayName(), this.plugin);
                if (!set.isEmpty()) {
                    set.put("adapti_on", 0);
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, wheret);
                    DamageUtility.run(this.plugin, DiskCircuit.CHAMELEON, id, this.player);
                }
            }
        }
    }

    private void updateChameleonSign(ArrayList<HashMap<String, String>> map, String preset, Player player) {
        for (HashMap<String, String> entry : map) {
            TARDISStaticUtils.setSign(entry.get("location"), 3, preset, player);
        }
    }
}

