/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetArtronStorage {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private int capacitors = 0;
    private int damaged = 0;
    private int task = -1;

    public ResultSetArtronStorage(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromID(int id) {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "eyes WHERE tardis_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.capacitors = rs.getInt("capacitors");
                    this.damaged = rs.getInt("damaged");
                    this.task = rs.getInt("task");
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for artron storage (eyes table)! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing artron storage (eyes table)! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getCapacitorCount() {
        return this.capacitors;
    }

    public int getDamageCount() {
        return this.damaged;
    }

    public int getTask() {
        return this.task;
    }
}

