/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.ConsoleDestroyer;
import me.eccentric_nz.TARDIS.console.ControlMonitor;
import me.eccentric_nz.TARDIS.console.models.ConsoleColourChanger;
import me.eccentric_nz.TARDIS.control.actions.ControlMenuAction;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class ScreenInteraction {
    private final TARDIS plugin;

    public ScreenInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void display(int id, Interaction interaction, boolean coords, Player player) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        if (player.isSneaking()) {
            TextDisplay display = this.getTextDisplay(interaction.getLocation(), coords, id);
            if (display != null) {
                display.setRotation(Location.normalizeYaw((float)120.0f), -7.5f);
                new ControlMonitor(this.plugin).update(id, display.getUniqueId(), coords);
            }
        } else {
            ItemStack hand = player.getInventory().getItemInMainHand();
            Material material = hand.getType();
            if (Tag.CONCRETE_POWDER.isTagged((Keyed)material) || material == Material.COPPER_INGOT) {
                int amount = hand.getAmount();
                if (amount < 6) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONSOLE_COLOUR_AMOUNT");
                    return;
                }
                String colour = material == Material.COPPER_INGOT ? "rustic" : material.toString().toLowerCase(Locale.ROOT).replace("_concrete_powder", "");
                String uuids = (String)interaction.getPersistentDataContainer().get(this.plugin.getUnaryKey(), PersistentDataType.STRING);
                if (uuids != null && new ConsoleColourChanger(this.plugin, interaction.getLocation(), uuids, colour).paint()) {
                    if (amount < 7) {
                        player.getInventory().setItemInMainHand(null);
                    } else {
                        hand.setAmount(amount - 6);
                        player.getInventory().setItemInMainHand(hand);
                    }
                }
            } else if (Tag.ITEMS_PICKAXES.isTagged((Keyed)hand.getType())) {
                ItemStack console;
                String uuids = (String)interaction.getPersistentDataContainer().get(this.plugin.getUnaryKey(), PersistentDataType.STRING);
                if (uuids != null && (console = new ConsoleDestroyer(this.plugin).returnStack(uuids, id)) != null) {
                    interaction.getWorld().dropItemNaturally(interaction.getLocation(), console);
                }
            } else {
                new ControlMenuAction(this.plugin).openGUI(player, id);
            }
        }
    }

    private TextDisplay getTextDisplay(Location location, boolean coords, int id) {
        TextDisplay textDisplay = null;
        Iterator iterator = location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0, e -> e.getType() == EntityType.TEXT_DISPLAY).iterator();
        if (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            textDisplay = (TextDisplay)entity;
        }
        if (textDisplay == null) {
            Location adjusted = location.clone();
            Vector vector = coords ? new Vector(-0.05, 0.5, -0.4) : new Vector(-0.25, 0.5, 0.125);
            adjusted.add(vector);
            this.plugin.setTardisSpawn(true);
            textDisplay = (TextDisplay)location.getWorld().spawnEntity(adjusted, EntityType.TEXT_DISPLAY);
            textDisplay.getPersistentDataContainer().set(this.plugin.getInteractionUuidKey(), PersistentDataType.BOOLEAN, (Object)true);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tardis_id", id);
            data.put("uuid", textDisplay.getUniqueId().toString());
            data.put("control", "SCREEN");
            data.put("state", 0);
            this.plugin.getQueryFactory().doInsert("interactions", data);
        }
        return textDisplay;
    }
}

