/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.wiki;

import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.dev.wiki.PageBuilder;
import me.eccentric_nz.TARDIS.info.TARDISDescription;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischemistry.block.ChemistryBlock;
import me.eccentric_nz.tardischemistry.block.RecipeData;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.element.Element;
import me.eccentric_nz.tardischemistry.product.Product;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.RecipeChoice;

public class ChemistryPageBuilder
extends PageBuilder {
    final Pattern regex = Pattern.compile("([A-Z_])+");
    private final TARDIS plugin;

    public ChemistryPageBuilder(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public boolean compile() {
        String data;
        for (Product p : Product.values()) {
            this.plugin.debug(p.toString());
            data = this.formatProduct(p);
            if (data.isEmpty()) continue;
            this.save(TARDISStringUtils.toDashedLowercase(p.toString()), data);
        }
        for (RecipeData block : ChemistryBlock.RECIPES.values()) {
            this.plugin.debug(block.nameSpacedKey());
            data = this.formatChemistryBlock(block);
            if (data.isEmpty()) continue;
            this.save(TARDISStringUtils.toDashedLowercase(block.displayName()), data);
        }
        return true;
    }

    private String formatChemistryBlock(RecipeData item) {
        String crafting = TARDISStringUtils.toLowercaseDashed(item.displayName());
        String mat = TARDISStringUtils.capitalise(item.craftMaterial().toString());
        String ingredients = "[" + mat + "](https://minecraft.wiki/w/" + mat.replaceAll(" ", "_") + ")<br/>[Crafting Table](https://minecraft.wiki/w/Crafting_Table)";
        String icon = TARDISStringUtils.toLowercaseDashed(mat);
        String table = "['" + icon + "','" + icon + "','" + icon + "','" + icon + "','crafting-table','" + icon + "','" + icon + "','" + icon + "','" + icon + "','" + crafting + "']";
        String SHAPELESS = "---\nlayout: default\ntitle: %s\n---\n\nimport Recipe from \"@site/src/components/Recipe\";\n\n%s\n===================\n\n%s\n\n## Crafting\n\n`/trecipe %s`\n\n| Ingredients | Crafting recipe |\n| ----------- | --------------- |\n| %s | <Recipe icons={%s} /> |\n";
        return String.format(SHAPELESS, item.displayName(), item.displayName(), StringUtils.join(item.lore(), (String)" "), crafting, ingredients, table);
    }

    private String formatProduct(Product product) {
        String item = product.toString().replaceAll("_", " ");
        String crafting = TARDISStringUtils.toLowercaseDashed(item);
        String[] data = this.getChemistryTable(product);
        String ingredients = data[0];
        String hardTable = data[1];
        String desc = String.format("The %s is used to ", item);
        try {
            String info = TARDISStringUtils.toEnumUppercase(item) + "_INFO";
            TARDISDescription description = TARDISDescription.valueOf(info);
            desc = description.getDesc();
        }
        catch (IllegalArgumentException info) {
            // empty catch block
        }
        String PROD = "---\nlayout: default\ntitle: %s\n---\n\nimport Recipe from \"@site/src/components/Recipe\";\n\n%s\n===================\n\n%s\n\n## Formula\n\n`/tchemistry formula %s`\n\n| Ingredients | Lab recipe |\n| ----------- | --------------- |\n| %s | <Recipe icons={%s} /> |\n";
        return String.format(PROD, item, item, desc, crafting, ingredients, hardTable);
    }

    private String[] getChemistryTable(Product p) {
        StringBuilder ingredientBuilder = new StringBuilder();
        StringBuilder tableBuilder = new StringBuilder("[");
        String[] shape = p.getRecipe().split("\\|");
        String[][] data = new String[3][3];
        data[0] = shape[0].split(",");
        data[1] = shape[1].split(",");
        data[2] = shape[2].split(",");
        HashSet<String> ingredients = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (data[i][j] == null || data[i][j].equals("-")) {
                    tableBuilder.append("'air',");
                    continue;
                }
                String dashed = "";
                try {
                    Material material = Material.valueOf((String)data[i][j]);
                    ingredients.add(material.toString());
                    dashed = TARDISStringUtils.toLowercaseDashed(TARDISStringUtils.capitalise(material.toString()));
                }
                catch (IllegalArgumentException me) {
                    try {
                        Compound compound = Compound.valueOf(data[i][j].replace(" ", "_"));
                        ingredients.add(data[i][j]);
                        dashed = TARDISStringUtils.toLowercaseDashed(data[i][j]);
                    }
                    catch (IllegalArgumentException ce) {
                        try {
                            Element element = Element.valueOf(data[i][j]);
                            ingredients.add(data[i][j]);
                            dashed = data[i][j].toLowerCase(Locale.ROOT);
                        }
                        catch (IllegalArgumentException element) {
                            // empty catch block
                        }
                    }
                }
                tableBuilder.append("'").append(dashed).append("'").append(",");
            }
        }
        String result = TARDISStringUtils.toDashedLowercase(p.toString());
        tableBuilder.append("'").append(result).append("'").append("]");
        String prefix = "";
        for (String s : ingredients) {
            Matcher matcher = this.regex.matcher(s);
            if (matcher.matches()) {
                Material mat = Material.valueOf((String)s);
                String link = this.getLink((RecipeChoice)new RecipeChoice.MaterialChoice(mat));
                ingredientBuilder.append(prefix);
                prefix = "<br/>";
                ingredientBuilder.append(link);
                continue;
            }
            ingredientBuilder.append(prefix);
            prefix = "<br/>";
            ingredientBuilder.append(s);
        }
        return new String[]{ingredientBuilder.toString(), tableBuilder.toString()};
    }
}

