/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.lists;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;

public class ConsoleCostLister {
    private final TARDIS plugin;
    private final HashMap<String, HashMap<String, Integer>> consoleBlockCounts = new HashMap();

    public ConsoleCostLister(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void actualArtron() {
        for (String string : Desktops.getBY_PERMS().keySet()) {
            HashMap<String, Integer> blockTypes = new HashMap<String, Integer>();
            JsonObject obj = SchematicGZip.getObject(this.plugin, "consoles", string, false);
            if (obj == null) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "The supplied file [" + string + ".tschm] is not a TARDIS JSON schematic!");
            } else {
                JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                int h = dimensions.get("height").getAsInt();
                int w = dimensions.get("width").getAsInt();
                int l = dimensions.get("length").getAsInt();
                JsonArray arr = obj.get("input").getAsJsonArray();
                for (int level = 0; level < h; ++level) {
                    JsonArray floor = arr.get(level).getAsJsonArray();
                    for (int row = 0; row < w; ++row) {
                        JsonArray r = floor.get(row).getAsJsonArray();
                        for (int col = 0; col < l; ++col) {
                            JsonObject c = r.get(col).getAsJsonObject();
                            String bid = this.getMaterialAsString(c.get("data").getAsString());
                            if (this.plugin.getBuildKeeper().getIgnoreBlocks().contains(bid)) continue;
                            if (blockTypes.containsKey(bid)) {
                                Integer count = (Integer)blockTypes.get(bid) + 1;
                                blockTypes.put(bid, count);
                                continue;
                            }
                            blockTypes.put(bid, 1);
                        }
                    }
                }
            }
            this.consoleBlockCounts.put(string, blockTypes);
        }
        for (Map.Entry entry : this.consoleBlockCounts.entrySet()) {
            int cost = 0;
            for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                String bid = (String)entry2.getKey();
                if (this.plugin.getBuildKeeper().getBlockConversion().containsKey(bid)) {
                    bid = this.plugin.getBuildKeeper().getBlockConversion().get(bid);
                }
                if (this.plugin.getCondensables().containsKey(bid)) {
                    int value = (Integer)entry2.getValue() * this.plugin.getCondensables().get(bid);
                    cost += value;
                    continue;
                }
                this.plugin.debug("Not in condensables: " + (String)entry2.getKey());
            }
            int artron_cost = Math.round((float)cost / 2.0f);
            float tmp_cost = (float)artron_cost / 10.0f;
            int config_cost = (int)tmp_cost / 25 * 25;
            int current_cost = this.plugin.getArtronConfig().getInt("upgrades." + (String)entry.getKey());
            this.plugin.debug("| " + TARDISStringUtils.capitalise((String)entry.getKey()) + " | " + artron_cost + " | " + config_cost + " |" + current_cost + " |");
        }
    }

    private String getMaterialAsString(String data) {
        String bid = "STONE";
        try {
            BlockData block = this.plugin.getServer().createBlockData(data);
            bid = block.getMaterial().toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return bid;
    }
}

