/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.config.AutonomousAreaCommand;
import me.eccentric_nz.TARDIS.commands.config.DefaultCommand;
import me.eccentric_nz.TARDIS.commands.config.DefaultWorldNameCommand;
import me.eccentric_nz.TARDIS.commands.config.LanguageCommand;
import me.eccentric_nz.TARDIS.commands.config.OptionsCommand;
import me.eccentric_nz.TARDIS.commands.config.PowerDownCommand;
import me.eccentric_nz.TARDIS.commands.config.ReloadCommand;
import me.eccentric_nz.TARDIS.commands.config.SetBooleanCommand;
import me.eccentric_nz.TARDIS.commands.config.SetIntegerCommand;
import me.eccentric_nz.TARDIS.commands.config.SetMaterialCommand;
import me.eccentric_nz.TARDIS.commands.config.SetRespectCommand;
import me.eccentric_nz.TARDIS.commands.config.SetWorldInclusionCommand;
import me.eccentric_nz.TARDIS.commands.config.SetZeroRoomCommand;
import me.eccentric_nz.TARDIS.commands.config.SiegeCommand;
import me.eccentric_nz.TARDIS.commands.config.SignColourCommand;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.UseClay;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class TARDISConfigCommand
implements CommandExecutor {
    final HashMap<String, String> firstsStr = new HashMap();
    final List<String> firstsStrArtron = new ArrayList<String>();
    final HashMap<String, String> firstsBool = new HashMap();
    final HashMap<String, String> firstsInt = new HashMap();
    final List<String> firstsIntArtron = new ArrayList<String>();
    private final TARDIS plugin;

    public TARDISConfigCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.firstsStr.put("area", "creation");
        this.firstsStr.put("autonomous_area", "");
        this.firstsStr.put("crafting", "difficulty");
        this.firstsStr.put("database", "storage");
        this.firstsStr.put("default_key", "preferences");
        this.firstsStr.put("default_model", "sonic");
        this.firstsStr.put("default_preset", "police_box");
        this.firstsStr.put("default_world_name", "creation");
        this.firstsStr.put("exclude", "");
        this.firstsStr.put("include", "");
        this.firstsStr.put("inventory_group", "creation");
        this.firstsStr.put("key", "preferences");
        this.firstsStr.put("language", "preferences");
        this.firstsStr.put("options", "");
        this.firstsStr.put("provider", "mapping");
        this.firstsStr.put("reload", "");
        this.firstsStr.put("respect_towny", "preferences");
        this.firstsStr.put("respect_worldguard", "preferences");
        this.firstsStr.put("seed_block.easy", "creation");
        this.firstsStr.put("seed_block.normal", "creation");
        this.firstsStr.put("seed_block.hard", "creation");
        this.firstsStr.put("siege", "siege");
        this.firstsStr.put("sign_colour", "police_box");
        this.firstsStr.put("tips_next", "creation");
        this.firstsStr.put("use_clay", "creation");
        this.firstsStr.put("vortex_fall", "preferences");
        this.firstsStrArtron.add("full_charge_item");
        this.firstsStrArtron.add("jettison_seed");
        this.firstsBool.put("3d_doors", "allow");
        this.firstsBool.put("abandon", "");
        this.firstsBool.put("achievements", "allow");
        this.firstsBool.put("add_lights", "allow");
        this.firstsBool.put("add_server_link", "preferences");
        this.firstsBool.put("admin_bypass", "allow");
        this.firstsBool.put("all_blocks", "allow");
        this.firstsBool.put("allow_end_after_visit", "travel");
        this.firstsBool.put("allow_nether_after_visit", "travel");
        this.firstsBool.put("animal_spawners", "allow");
        this.firstsBool.put("animated_door", "police_box");
        this.firstsBool.put("any_key", "preferences");
        this.firstsBool.put("archive", "");
        this.firstsBool.put("autonomous", "allow");
        this.firstsBool.put("biome_reader", "difficulty");
        this.firstsBool.put("blueprints", "modules");
        this.firstsBool.put("chameleon", "travel");
        this.firstsBool.put("charge", "sonic");
        this.firstsBool.put("check_blocks_before_upgrade", "desktop");
        this.firstsBool.put("check_for_home", "creation");
        this.firstsBool.put("chemistry", "modules");
        this.firstsBool.put("circuits", "difficulty");
        this.firstsBool.put("create_worlds", "creation");
        this.firstsBool.put("create_worlds_with_perms", "creation");
        this.firstsBool.put("damage", "circuits");
        this.firstsBool.put("debug", "");
        this.firstsBool.put("default_world", "creation");
        this.firstsBool.put("disk_in_hand_for_write", "difficulty");
        this.firstsBool.put("disks", "difficulty");
        this.firstsBool.put("dynamic_lamps", "allow");
        this.firstsBool.put("emergency_npc", "allow");
        this.firstsBool.put("exile", "travel");
        this.firstsBool.put("external_gravity", "allow");
        this.firstsBool.put("furnace_particles", "artron_furnace");
        this.firstsBool.put("give_key", "travel");
        this.firstsBool.put("guardians", "allow");
        this.firstsBool.put("hads", "allow");
        this.firstsBool.put("handles", "allow");
        this.firstsBool.put("include_default_world", "travel");
        this.firstsBool.put("invisibility", "allow");
        this.firstsBool.put("keep_night", "creation");
        this.firstsBool.put("land_on_water", "travel");
        this.firstsBool.put("load_shells", "police_box");
        this.firstsBool.put("mapping", "modules");
        this.firstsBool.put("materialise", "police_box");
        this.firstsBool.put("mob_farming", "allow");
        this.firstsBool.put("name_tardis", "police_box");
        this.firstsBool.put("nerf_pistons.enabled", "preferences");
        this.firstsBool.put("nerf_pistons.only_tardis_worlds", "preferences");
        this.firstsBool.put("nether", "travel");
        this.firstsBool.put("no_coords", "preferences");
        this.firstsBool.put("no_creative_condense", "preferences");
        this.firstsBool.put("no_destination_malfunctions", "travel");
        this.firstsBool.put("no_enchanted_condense", "preferences");
        this.firstsBool.put("open_door_policy", "preferences");
        this.firstsBool.put("particles", "eye_of_harmony");
        this.firstsBool.put("per_world_perms", "travel");
        this.firstsBool.put("perception_filter", "allow");
        this.firstsBool.put("power_down", "allow");
        this.firstsBool.put("power_down_on_quit", "allow");
        this.firstsBool.put("previews", "desktop");
        this.firstsBool.put("reduce_count", "abandon");
        this.firstsBool.put("regeneration", "modules");
        this.firstsBool.put("render_entities", "preferences");
        this.firstsBool.put("respect_chunky_border", "preferences");
        this.firstsBool.put("respect_grief_prevention", "preferences");
        this.firstsBool.put("respect_worldborder", "preferences");
        this.firstsBool.put("return_room_seed", "growth");
        this.firstsBool.put("rooms_require_blocks", "growth");
        this.firstsBool.put("seed_block.crafting", "creation");
        this.firstsBool.put("seed_block.legacy", "creation");
        this.firstsBool.put("sfx", "allow");
        this.firstsBool.put("shop", "modules");
        this.firstsBool.put("sonic_blaster", "modules");
        this.firstsBool.put("spawn_eggs", "allow");
        this.firstsBool.put("spawn_random_monsters", "preferences");
        this.firstsBool.put("stattenheim_remote", "difficulty");
        this.firstsBool.put("strike_lightning", "preferences");
        this.firstsBool.put("switch_resource_packs", "");
        this.firstsBool.put("system_upgrades", "difficulty");
        this.firstsBool.put("tardis_locator", "difficulty");
        this.firstsBool.put("terminal.redefine", "travel");
        this.firstsBool.put("the_end", "travel");
        this.firstsBool.put("update.auto_update", "preferences");
        this.firstsBool.put("update.notify", "preferences");
        this.firstsBool.put("use_default_condensables", "preferences");
        this.firstsBool.put("use_nick", "police_box");
        this.firstsBool.put("use_worldguard", "preferences");
        this.firstsBool.put("view_interior", "police_box");
        this.firstsBool.put("view_interior_uses_console_size", "police_box");
        this.firstsBool.put("village_travel", "allow");
        this.firstsBool.put("vortex_manipulator", "modules");
        this.firstsBool.put("weather_set", "allow");
        this.firstsBool.put("weeping_angels", "modules");
        this.firstsBool.put("wg_flag_set", "allow");
        this.firstsBool.put("zero_room", "allow");
        this.firstsInt.put("ars_limit", "growth");
        this.firstsInt.put("block_change_percent", "desktop");
        this.firstsInt.put("border_radius", "creation");
        this.firstsInt.put("charge_interval", "sonic");
        this.firstsInt.put("charge_level", "sonic");
        this.firstsInt.put("conversion_radius", "sonic");
        this.firstsInt.put("count", "creation");
        this.firstsInt.put("delay_factor", "growth");
        this.firstsInt.put("force_field", "allow");
        this.firstsInt.put("freeze_cooldown", "sonic");
        this.firstsInt.put("grace_period", "travel");
        this.firstsInt.put("gravity_max_distance", "growth");
        this.firstsInt.put("gravity_max_velocity", "growth");
        this.firstsInt.put("hads_damage", "preferences");
        this.firstsInt.put("hads_distance", "preferences");
        this.firstsInt.put("heal_speed", "preferences");
        this.firstsInt.put("malfunction", "preferences");
        this.firstsInt.put("malfunction_end", "preferences");
        this.firstsInt.put("malfunction_nether", "preferences");
        this.firstsInt.put("min_time", "arch");
        this.firstsInt.put("random_attempts", "travel");
        this.firstsInt.put("random_circuit.x", "travel");
        this.firstsInt.put("random_circuit.z", "travel");
        this.firstsInt.put("room_speed", "growth");
        this.firstsInt.put("rooms_condenser_percent", "growth");
        this.firstsInt.put("sfx_volume", "preferences");
        this.firstsInt.put("terminal_step", "travel");
        this.firstsInt.put("timeout", "travel");
        this.firstsInt.put("timeout_height", "travel");
        this.firstsInt.put("tips_limit", "creation");
        this.firstsInt.put("tp_radius", "travel");
        this.firstsInt.put("update_period", "mapping");
        this.firstsInt.put("updates_per_tick", "mapping");
        this.firstsInt.put("usage", "sonic");
        this.firstsInt.put("uses.ars", "circuits");
        this.firstsInt.put("uses.chameleon", "circuits");
        this.firstsInt.put("uses.input", "circuits");
        this.firstsInt.put("uses.invisibility", "circuits");
        this.firstsInt.put("uses.materialisation", "circuits");
        this.firstsInt.put("uses.memory", "circuits");
        this.firstsInt.put("uses.randomiser", "circuits");
        this.firstsInt.put("uses.scanner", "circuits");
        this.firstsInt.put("uses.temporal", "circuits");
        this.firstsInt.put("wall_data", "police_box");
        this.firstsInt.put("wall_id", "police_box");
        this.firstsIntArtron.add("autonomous");
        this.firstsIntArtron.add("backdoor");
        this.firstsIntArtron.add("comehere");
        this.firstsIntArtron.add("creeper_recharge");
        this.firstsIntArtron.add("full_charge");
        this.firstsIntArtron.add("hide");
        this.firstsIntArtron.add("jettison");
        this.firstsIntArtron.add("lightning_recharge");
        this.firstsIntArtron.add("nether_min");
        this.firstsIntArtron.add("player");
        this.firstsIntArtron.add("random");
        this.firstsIntArtron.add("recharge_distance");
        this.firstsIntArtron.add("the_end_min");
        this.firstsIntArtron.add("travel");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisconfig")) {
            if (sender instanceof ConsoleCommandSender || sender.hasPermission("tardis.admin")) {
                if (args.length == 0) {
                    new TARDISCommandHelper(this.plugin).getCommand("tardisconfig", sender);
                    return true;
                }
                String first = args[0].toLowerCase(Locale.ROOT);
                if (!(this.firstsStr.containsKey(first) || this.firstsBool.containsKey(first) || this.firstsInt.containsKey(first) || this.firstsIntArtron.contains(first) || this.firstsStrArtron.contains(first))) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_NOT_VALID");
                    return false;
                }
                if (args.length == 1 && first.equals("reload")) {
                    return new ReloadCommand(this.plugin).reloadConfig(sender);
                }
                if (args.length < 2) {
                    boolean isMainConfig = true;
                    Object path = "";
                    if (this.firstsStr.containsKey(first)) {
                        path = this.firstsStr.get(first) + "." + first;
                    } else if (this.firstsBool.containsKey(first)) {
                        path = this.firstsBool.get(first) + "." + first;
                    } else if (this.firstsInt.containsKey(first)) {
                        path = this.firstsInt.get(first) + "." + first;
                    } else if (this.firstsStrArtron.contains(first) || this.firstsIntArtron.contains(first)) {
                        isMainConfig = false;
                        path = first;
                    }
                    if (isMainConfig) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_OPTION", path, this.plugin.getConfig().getString((String)path));
                    } else {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_OPTION_ARTRON", first, this.plugin.getArtronConfig().getString((String)path));
                    }
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_OPTION_SET", first);
                    return true;
                }
                if (first.equals("provider")) {
                    String provider = args[1];
                    if (!(provider.equals("dynmap") || provider.equals("BlueMap") || provider.equals("squaremap"))) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_PROVIDER");
                        return true;
                    }
                    this.plugin.getConfig().set("mapping.provider", (Object)provider);
                }
                if (first.equals("reload")) {
                    return new ReloadCommand(this.plugin).reloadOtherConfig(sender, args);
                }
                if (first.equals("area")) {
                    this.plugin.getConfig().set("creation.area", (Object)args[1]);
                }
                if (first.equals("autonomous_area")) {
                    return new AutonomousAreaCommand(this.plugin).processArea(sender, args);
                }
                if (first.equals("options")) {
                    return new OptionsCommand(this.plugin).showConfigOptions(sender, args);
                }
                if (first.equals("language")) {
                    return new LanguageCommand(this.plugin).setLanguage(sender, args);
                }
                if (first.equals("power_down")) {
                    return new PowerDownCommand(this.plugin).togglePowerDown(sender, args);
                }
                if (first.equals("database")) {
                    String dbtype = args[1].toLowerCase(Locale.ROOT);
                    if (!dbtype.equals("mysql") && !dbtype.equals("sqlite")) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_DB");
                        return true;
                    }
                    this.plugin.getConfig().set("database", (Object)dbtype);
                }
                if (first.equals("include") || first.equals("exclude")) {
                    return new SetWorldInclusionCommand(this.plugin).setWorldStatus(sender, args);
                }
                if (first.equals("siege")) {
                    return new SiegeCommand(this.plugin).setOption(sender, args);
                }
                if (first.equals("sign_colour")) {
                    return new SignColourCommand(this.plugin).setColour(sender, args);
                }
                if (first.equals("key")) {
                    return new SetMaterialCommand(this.plugin).setConfigMaterial(sender, args, this.firstsStr.get(first));
                }
                if (first.equals("full_charge_item") || first.equals("jettison_seed")) {
                    return new SetMaterialCommand(this.plugin).setConfigMaterial(sender, args);
                }
                if (first.equals("default_key") || first.equals("default_model")) {
                    return new DefaultCommand(this.plugin).setDefaultItem(sender, args);
                }
                if (first.equals("default_world_name")) {
                    return new DefaultWorldNameCommand(this.plugin).setName(sender, args);
                }
                if (first.equals("respect_towny")) {
                    return new SetRespectCommand(this.plugin).setRegion(sender, args);
                }
                if (first.equals("respect_worldguard")) {
                    return new SetRespectCommand(this.plugin).setFlag(sender, args);
                }
                if (first.equals("crafting")) {
                    if (!args[1].equalsIgnoreCase("easy") && !args[1].equalsIgnoreCase("hard")) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_DIFF");
                        return true;
                    }
                    this.plugin.getConfig().set("difficulty.crafting", (Object)args[1].toLowerCase(Locale.ROOT));
                    this.plugin.setDifficulty(CraftingDifficulty.valueOf(args[1].toUpperCase(Locale.ROOT)));
                }
                if (first.equals("default_preset")) {
                    if (this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false).contains(args[1])) {
                        this.plugin.getConfig().set("police_box.default_preset", (Object)("ITEM:" + args[1]));
                    } else {
                        try {
                            ChameleonPreset.valueOf(args[1].toUpperCase(Locale.ROOT));
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_PRESET");
                            return true;
                        }
                        this.plugin.getConfig().set("police_box.default_preset", (Object)args[1].toUpperCase(Locale.ROOT));
                    }
                }
                if (first.equals("use_clay")) {
                    try {
                        UseClay.valueOf(args[1].toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_USE_CLAY");
                        return true;
                    }
                    this.plugin.getConfig().set("creation.use_clay", (Object)args[1].toUpperCase(Locale.ROOT));
                }
                if (first.equals("inventory_group")) {
                    this.plugin.getConfig().set("creation.inventory_group", (Object)args[1]);
                }
                if (first.equals("vortex_fall")) {
                    if (!args[1].equalsIgnoreCase("kill") && !args[1].equalsIgnoreCase("teleport")) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_VORTEX");
                        return true;
                    }
                    this.plugin.getConfig().set("preferences.vortex_fall", (Object)args[1].toLowerCase(Locale.ROOT));
                }
                if (this.firstsBool.containsKey(first)) {
                    if (first.equals("zero_room")) {
                        return new SetZeroRoomCommand(this.plugin).setConfigZero(sender, args);
                    }
                    return new SetBooleanCommand(this.plugin).setConfigBool(sender, args, this.firstsBool.get(first));
                }
                if (this.firstsInt.containsKey(first)) {
                    if (first.startsWith("random_circuit.")) {
                        return new SetIntegerCommand(this.plugin).setRandomInt(sender, args);
                    }
                    return new SetIntegerCommand(this.plugin).setConfigInt(sender, args, this.firstsInt.get(first));
                }
                if (this.firstsIntArtron.contains(first)) {
                    return new SetIntegerCommand(this.plugin).setConfigInt(sender, args);
                }
                this.plugin.saveConfig();
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
                return true;
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
            return false;
        }
        return false;
    }
}

