/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.gui;

import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPoliceBoxes;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPresets;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ModelledPresetInventory
implements InventoryHolder {
    private final List<String> colours = List.of("Blue", "White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Brown", "Green", "Red", "Black");
    private final TARDIS plugin;
    private final Player player;
    private final Inventory inventory;

    public ModelledPresetInventory(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Chameleon Police Boxes", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] boxes = new ItemStack[54];
        int i = 0;
        for (String s : this.colours) {
            String underscored = s.replace(" ", "_");
            if (TARDISPermission.hasPermission(this.player, "tardis.preset.police_box_" + underscored.toLowerCase(Locale.ROOT))) {
                String dye = underscored.toUpperCase(Locale.ROOT) + "_DYE";
                ItemStack is = ItemStack.of((Material)Material.valueOf((String)dye), (int)1);
                ItemMeta im = is.getItemMeta();
                im.displayName((Component)Component.text((String)(s + " Police Box")));
                switch (s) {
                    case "Blue": {
                        im.setItemModel(ChameleonVariant.BLUE_CLOSED.getKey());
                        break;
                    }
                    case "White": {
                        im.setItemModel(ChameleonVariant.WHITE_CLOSED.getKey());
                        break;
                    }
                    case "Orange": {
                        im.setItemModel(ChameleonVariant.ORANGE_CLOSED.getKey());
                        break;
                    }
                    case "Magenta": {
                        im.setItemModel(ChameleonVariant.MAGENTA_CLOSED.getKey());
                        break;
                    }
                    case "Light Blue": {
                        im.setItemModel(ChameleonVariant.LIGHT_BLUE_CLOSED.getKey());
                        break;
                    }
                    case "Yellow": {
                        im.setItemModel(ChameleonVariant.YELLOW_CLOSED.getKey());
                        break;
                    }
                    case "Lime": {
                        im.setItemModel(ChameleonVariant.LIME_CLOSED.getKey());
                        break;
                    }
                    case "Pink": {
                        im.setItemModel(ChameleonVariant.PINK_CLOSED.getKey());
                        break;
                    }
                    case "Gray": {
                        im.setItemModel(ChameleonVariant.GRAY_CLOSED.getKey());
                        break;
                    }
                    case "Light Gray": {
                        im.setItemModel(ChameleonVariant.LIGHT_GRAY_CLOSED.getKey());
                        break;
                    }
                    case "Cyan": {
                        im.setItemModel(ChameleonVariant.CYAN_CLOSED.getKey());
                        break;
                    }
                    case "Purple": {
                        im.setItemModel(ChameleonVariant.PURPLE_CLOSED.getKey());
                        break;
                    }
                    case "Brown": {
                        im.setItemModel(ChameleonVariant.BROWN_CLOSED.getKey());
                        break;
                    }
                    case "Green": {
                        im.setItemModel(ChameleonVariant.GREEN_CLOSED.getKey());
                        break;
                    }
                    case "Red": {
                        im.setItemModel(ChameleonVariant.RED_CLOSED.getKey());
                        break;
                    }
                    case "Black": {
                        im.setItemModel(ChameleonVariant.BLACK_CLOSED.getKey());
                    }
                }
                is.setItemMeta(im);
                boxes[i] = is;
            }
            ++i;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.preset.police_box_tennant")) {
            ItemStack david = ItemStack.of((Material)Material.CYAN_STAINED_GLASS_PANE, (int)1);
            ItemMeta tennant = david.getItemMeta();
            tennant.displayName((Component)Component.text((String)"Tennant Era Police Box"));
            tennant.setItemModel(ChameleonVariant.TENNANT_CLOSED.getKey());
            david.setItemMeta(tennant);
            boxes[i] = david;
            ++i;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.preset.weeping_angel")) {
            ItemStack is = ItemStack.of((Material)Material.GRAY_STAINED_GLASS_PANE, (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)"Weeping Angel"));
            im.setItemModel(ChameleonVariant.WEEPING_ANGEL_CLOSED.getKey());
            is.setItemMeta(im);
            boxes[i] = is;
            ++i;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.preset.pandorica")) {
            ItemStack pan = ItemStack.of((Material)Material.ENDER_PEARL, (int)1);
            ItemMeta ica = pan.getItemMeta();
            ica.displayName((Component)Component.text((String)"Pandorica"));
            ica.setItemModel(ChameleonVariant.PANDORICA_CLOSED.getKey());
            pan.setItemMeta(ica);
            boxes[i] = pan;
            ++i;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.preset.sidrat")) {
            ItemStack sid = ItemStack.of((Material)Material.GREEN_STAINED_GLASS_PANE, (int)1);
            ItemMeta rat = sid.getItemMeta();
            rat.displayName((Component)Component.text((String)"SIDRAT"));
            rat.setItemModel(ChameleonVariant.SIDRAT_CLOSED.getKey());
            sid.setItemMeta(rat);
            boxes[i] = sid;
            ++i;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.preset.battle")) {
            ItemStack bat = ItemStack.of((Material)Material.RED_STAINED_GLASS_PANE, (int)1);
            ItemMeta tle = bat.getItemMeta();
            tle.displayName((Component)Component.text((String)"Battle TARDIS"));
            tle.setItemModel(ChameleonVariant.BATTLE_CLOSED.getKey());
            bat.setItemMeta(tle);
            boxes[i] = bat;
            ++i;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.preset.police_box_tinted")) {
            ItemStack any = ItemStack.of((Material)Material.LEATHER_HORSE_ARMOR, (int)1);
            ItemMeta colour = any.getItemMeta();
            colour.displayName((Component)Component.text((String)"Pick a colour Police Box"));
            colour.setItemModel(ColouredVariant.TINTED_CLOSED.getKey());
            any.setItemMeta(colour);
            boxes[i] = any;
            ++i;
        }
        for (String custom : this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
            if (i >= 50) continue;
            try {
                Material cm = Material.valueOf((String)this.plugin.getCustomModelConfig().getString("models." + custom + ".item"));
                ItemStack cis = ItemStack.of((Material)cm);
                ItemMeta cim = cis.getItemMeta();
                cim.displayName((Component)Component.text((String)custom));
                String key = TARDISStringUtils.toUnderscoredLowercase(custom);
                cim.setItemModel(new NamespacedKey((Plugin)this.plugin, key + "_closed"));
                cis.setItemMeta(cim);
                boxes[i] = cis;
                ++i;
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Invalid material specified for custom model preset: " + custom + "!");
            }
        }
        ItemStack custom = ItemStack.of((Material)GUIChameleonPresets.CUSTOM.material(), (int)1);
        ItemMeta customMeta = custom.getItemMeta();
        customMeta.displayName((Component)Component.text((String)"Custom presets"));
        custom.setItemMeta(customMeta);
        boxes[GUIChameleonPresets.CUSTOM.slot()] = custom;
        ItemStack page = ItemStack.of((Material)GUIChameleonPoliceBoxes.GO_TO_PAGE_1.material(), (int)1);
        ItemMeta one = page.getItemMeta();
        one.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_PAGE_1")));
        page.setItemMeta(one);
        boxes[GUIChameleonPoliceBoxes.GO_TO_PAGE_1.slot()] = page;
        ItemStack back = ItemStack.of((Material)GUIChameleonPoliceBoxes.BACK.material(), (int)1);
        ItemMeta but = back.getItemMeta();
        but.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(but);
        boxes[GUIChameleonPoliceBoxes.BACK.slot()] = back;
        ItemStack close = ItemStack.of((Material)GUIChameleonPoliceBoxes.CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        boxes[GUIChameleonPoliceBoxes.CLOSE.slot()] = close;
        return boxes;
    }
}

