/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.toclafane;

import java.util.Collection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.monsters.toclafane.ToclafaneEquipment;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BeeSpawnListener
implements Listener {
    private final TARDIS plugin;

    public BeeSpawnListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBeeSpawnEvent(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.getType().equals((Object)EntityType.BEE)) {
            return;
        }
        World world = entity.getWorld();
        int limit = this.plugin.getMonstersConfig().getInt("tocalane.worlds." + world.getName());
        if (limit < 1) {
            return;
        }
        int n = 0;
        Collection hive = world.getEntitiesByClass(Bee.class);
        for (Bee b : hive) {
            if (b.getPassengers().isEmpty() || !(b.getPassengers().getFirst() instanceof ArmorStand)) continue;
            ++n;
        }
        if (n < limit && TARDISConstants.RANDOM.nextInt(100) < this.plugin.getMonstersConfig().getInt("toclafane.spawn_from_bee")) {
            Entity toclafane = world.spawnEntity(entity.getLocation(), EntityType.ARMOR_STAND);
            ToclafaneEquipment.set(toclafane, false);
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent(toclafane, EntityType.ARMOR_STAND, Monster.TOCLAFANE, entity.getLocation()));
            entity.remove();
        }
    }
}

