/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.lazarus.disguise.EmergencyProgramOneSpawner;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISEPSRunnable
implements Runnable {
    private final TARDIS plugin;
    private final String message;
    private final Player tl;
    private final List<UUID> players;
    private final int id;
    private final String eps;
    private final String creeper;

    public TARDISEPSRunnable(TARDIS plugin, String message, Player tl, List<UUID> players, int id, String eps, String creeper) {
        this.plugin = plugin;
        this.message = message;
        this.tl = tl;
        this.players = players;
        this.id = id;
        this.eps = eps;
        this.creeper = creeper;
    }

    private static float getCorrectYaw(double px1, double pz1, double px2, double pz2) {
        double xDiff = px2 - px1;
        double zDiff = pz2 - pz1;
        return (float)Math.toDegrees(Math.atan2(zDiff, xDiff)) + 90.0f;
    }

    @Override
    public void run() {
        Location location = this.getSpawnLocation(this.id);
        if (location != null) {
            try {
                TARDISSounds.playTARDISSound(location, "tardis_takeoff");
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> TARDISSounds.playTARDISSound(location, "tardis_land"), 490L);
                this.plugin.setTardisSpawn(true);
                if (!this.eps.isEmpty()) {
                    String[] creep = this.creeper.split(":");
                    double cx = TARDISNumberParsers.parseDouble(creep[1]);
                    double cz = TARDISNumberParsers.parseDouble(creep[3]);
                    float yaw = TARDISEPSRunnable.getCorrectYaw(cx, cz, location.getX(), location.getZ());
                    location.setYaw(yaw);
                }
                EmergencyProgramOneSpawner spawner = new EmergencyProgramOneSpawner(this.tl, location);
                spawner.create();
                this.players.forEach(p -> {
                    Player pp = this.plugin.getServer().getPlayer(p);
                    if (pp != null) {
                        this.plugin.getMessenger().message((CommandSender)pp, TardisModule.EMERGENCY_PROGRAM, this.message);
                    }
                });
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.players.forEach(p -> {
                        Player pp = this.plugin.getServer().getPlayer(p);
                        if (pp != null) {
                            this.plugin.getMessenger().message((CommandSender)pp, TardisModule.EMERGENCY_PROGRAM, this.plugin.getLanguage().getString("EP1_BYE"));
                        }
                    });
                    spawner.getMannequin().remove();
                }, 1000L);
            }
            catch (CommandException e) {
                this.plugin.debug(e.getMessage());
            }
        }
    }

    private Location getSpawnLocation(int id) {
        if (!this.eps.isEmpty()) {
            return TARDISStaticLocationGetters.getLocationFromDB(this.eps);
        }
        if (this.plugin.getConfig().getBoolean("creation.create_worlds")) {
            if (TARDISFloodgate.shouldReplacePrefix(this.tl.getName())) {
                return this.plugin.getServer().getWorld(TARDISFloodgate.getPlayerWorldName(this.tl.getName())).getSpawnLocation();
            }
            return this.plugin.getServer().getWorld("TARDIS_WORLD_" + this.tl.getName()).getSpawnLocation();
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("door_type", 1);
        ResultSetDoors rsd = new ResultSetDoors(this.plugin, where, false);
        if (rsd.resultSet()) {
            double x;
            Location location = TARDISStaticLocationGetters.getLocationFromDB(rsd.getDoor_location());
            return location.add(x, 0.0, switch (rsd.getDoor_direction()) {
                case COMPASS.NORTH -> {
                    x = 0.5;
                    yield -1.5;
                }
                case COMPASS.EAST -> {
                    x = 1.5;
                    yield 0.5;
                }
                case COMPASS.WEST -> {
                    x = -1.5;
                    yield 0.5;
                }
                default -> {
                    x = 0.5;
                    yield 1.5;
                }
            });
        }
        return null;
    }
}

