/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.rooms.library.EnchantmentShelf;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.ChiseledBookshelf;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.Plugin;

public class LibrarySorter {
    private final TARDIS plugin;

    public LibrarySorter(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void distribute(Inventory inventory, Location start) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack is : inventory.getContents()) {
            if (is == null) continue;
            if (is.getType() == Material.ENCHANTED_BOOK && is.hasItemMeta()) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)is.getItemMeta();
                Map enchantments = esm.getStoredEnchants();
                if (enchantments.isEmpty()) continue;
                Map.Entry entry = enchantments.entrySet().iterator().next();
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                EnchantmentShelf shelf = EnchantmentShelf.BY_ENCHANTMENT.get(enchantment);
                Block block = start.clone().add(shelf.getPosition()).getBlock().getRelative(BlockFace.UP, level);
                if (block.getType() != Material.CHISELED_BOOKSHELF) continue;
                ChiseledBookshelf cbs = (ChiseledBookshelf)block.getState();
                HashMap add = cbs.getInventory().addItem(new ItemStack[]{is});
                if (!add.isEmpty()) {
                    leftovers.add(is);
                }
                inventory.remove(is);
                continue;
            }
            if (!this.isBook(is.getType())) continue;
            Block block = start.clone().add((switch (is.getType()) {
                case Material.BOOK -> EnchantmentShelf.BOOKS;
                case Material.WRITABLE_BOOK -> EnchantmentShelf.BOOK_AND_QUILLS;
                case Material.WRITTEN_BOOK -> EnchantmentShelf.WRITTEN_BOOKS;
                default -> EnchantmentShelf.KNOWLEDGE_BOOKS;
            }).getPosition()).getBlock().getRelative(BlockFace.UP);
            if (block.getType() != Material.CHISELED_BOOKSHELF) continue;
            ChiseledBookshelf cbs = (ChiseledBookshelf)block.getState();
            for (int l = 1; cbs.getInventory().firstEmpty() == -1 && l < 4; ++l) {
                cbs = (ChiseledBookshelf)block.getRelative(BlockFace.UP, l).getState();
            }
            HashMap add = cbs.getInventory().addItem(new ItemStack[]{is});
            if (!add.isEmpty()) {
                leftovers.add(is);
            }
            inventory.remove(is);
        }
        if (!leftovers.isEmpty()) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                for (ItemStack stack : leftovers) {
                    inventory.addItem(new ItemStack[]{stack});
                }
            }, 2L);
        }
    }

    private boolean isBook(Material material) {
        switch (material) {
            case BOOK: 
            case WRITABLE_BOOK: 
            case WRITTEN_BOOK: 
            case KNOWLEDGE_BOOK: {
                return true;
            }
        }
        return false;
    }
}

