/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISRecipeInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final RecipeCategory category;
    private final HashMap<String, String> recipeItems = new HashMap();
    private final Inventory inventory;

    TARDISRecipeInventory(TARDIS plugin, RecipeCategory category) {
        for (RecipeItem recipeItem : RecipeItem.values()) {
            if (recipeItem.getCategory() == RecipeCategory.UNUSED || recipeItem.getCategory() == RecipeCategory.UNCRAFTABLE) continue;
            this.recipeItems.put(recipeItem.toString(), recipeItem.toTabCompletionString());
        }
        this.plugin = plugin;
        this.category = category;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)"TARDIS Recipes", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[27];
        ItemStack back = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta but = back.getItemMeta();
        but.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(but);
        stack[0] = back;
        ItemStack info = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta info_im = info.getItemMeta();
        info_im.displayName((Component)Component.text((String)"Info"));
        info_im.lore(List.of(Component.text((String)"Click a button below"), Component.text((String)"to see the recipe"), Component.text((String)"for that item")));
        info.setItemMeta(info_im);
        stack[4] = info;
        ItemStack close = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta close_im = close.getItemMeta();
        close_im.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(close_im);
        stack[8] = close;
        int i = 9;
        for (RecipeItem item : RecipeItem.values()) {
            ItemStack result;
            if (item.getCategory() != this.category) continue;
            String arg = this.recipeItems.get(item.toString());
            String str = item.toRecipeString();
            if (arg == null) continue;
            if (this.isShapeless(str)) {
                ShapelessRecipe shapeless = this.plugin.getIncomposita().getShapelessRecipes().get(str);
                if (shapeless == null) {
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, "Could not get shapeless recipe item: " + String.valueOf((Object)item));
                    continue;
                }
                result = shapeless.getResult();
            } else {
                ShapedRecipe shaped = this.plugin.getFigura().getShapedRecipes().get(str);
                if (shaped == null) {
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, "Could not get shaped recipe item: " + String.valueOf((Object)item));
                    continue;
                }
                result = shaped.getResult();
            }
            ItemMeta im = result.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite(str));
            im.lore(List.of(Component.text((String)("/trecipe " + arg))));
            im.addItemFlags(ItemFlag.values());
            im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
            result.setItemMeta(im);
            stack[i] = result;
            ++i;
        }
        return stack;
    }

    private boolean isShapeless(String s) {
        return !s.equals("Blank Storage Disk") && !s.equals("Authorised Control Disk") && (s.contains("Jelly") || s.contains("Disk") || s.equals("Bowl of Custard") || s.equals("TARDIS Schematic Wand") || s.contains("Upgrade") || s.equals("Judoon Ammunition"));
    }
}

