/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners.controls;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.camera.TARDISCamera;
import me.eccentric_nz.TARDIS.custommodels.keys.ModelledControl;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.monitor.MonitorSnapshot;
import me.eccentric_nz.TARDIS.monitor.MonitorUtils;
import me.eccentric_nz.TARDIS.monitor.Snapshot;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISMonitorFrameListener
implements Listener {
    private final TARDIS plugin;

    public TARDISMonitorFrameListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onMonitorFrameClick(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            Player player = event.getPlayer();
            Location l = frame.getLocation();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("location", l.toString());
            where.put("type", 46);
            ResultSetControls rs = new ResultSetControls(this.plugin, where, false);
            if (rs.resultSet()) {
                UUID uuid = player.getUniqueId();
                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.MONITOR)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "TARDIS Monitor");
                    return;
                }
                if (player.isSneaking() && TARDISPermission.hasPermission(player, "tardis.camera")) {
                    if (this.isTravelling(rs.getTardis_id())) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAMERA_NO_TRAVEL");
                        return;
                    }
                    ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
                    if (rsp.fromID(rs.getTardis_id()) && rsp.getPreset().usesArmourStand()) {
                        new TARDISCamera(this.plugin).viewExterior(player, rs.getTardis_id());
                    }
                } else {
                    ItemStack is = frame.getItem();
                    ItemMeta im = is.getItemMeta();
                    if (im.hasItemModel()) {
                        ItemStack map;
                        NamespacedKey cmd = im.getItemModel();
                        switch (cmd.getKey().split("_")[2]) {
                            case "left": {
                                im.setItemModel(ModelledControl.MONITOR_FRAME_MIDDLE.getKey());
                                break;
                            }
                            case "middle": {
                                im.setItemModel(ModelledControl.MONITOR_FRAME_RIGHT.getKey());
                                break;
                            }
                            default: {
                                im.setItemModel(ModelledControl.MONITOR_FRAME_LEFT.getKey());
                            }
                        }
                        is.setItemMeta(im);
                        frame.setItem(is);
                        ItemFrame mapFrame = MonitorUtils.getItemFrameFromLocation(l, frame.getUniqueId());
                        if (mapFrame != null && (map = mapFrame.getItem()).getType() == Material.FILLED_MAP) {
                            int id;
                            Snapshot snapshot;
                            Location door;
                            HashMap<String, Object> wheret = new HashMap<String, Object>();
                            wheret.put("uuid", uuid.toString());
                            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
                            if (rst.resultSet() && (door = (snapshot = MonitorUtils.getLocationAndDirection(id = rst.getTardis_id(), false)).location()) != null) {
                                MonitorSnapshot.loadChunks(this.plugin, door, false, snapshot.direction(), id, 128);
                                MonitorUtils.updateSnapshot(door, 128, map);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean isTravelling(int id) {
        return this.plugin.getTrackerKeeper().getDematerialising().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id);
    }
}

