/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateBiomesForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateStructuresForm;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateTelepathicForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final int id;

    public FloodgateTelepathicForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("Telepathic Location Finder");
        builder.button("Toggle telepathic circuit", FormImage.Type.PATH, "textures/block/daylight_detector_top.png");
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (TARDISPermission.hasPermission(player, "tardis.timetravel.cave")) {
            builder.button("Cave finder", FormImage.Type.PATH, "textures/block/dripstone_block.png");
        }
        if (TARDISPermission.hasPermission(player, "tardis.timetravel.village")) {
            builder.button("Structure finder", FormImage.Type.PATH, "textures/block/hay_block_side.png");
        }
        if (TARDISPermission.hasPermission(player, "tardis.timetravel.biome")) {
            builder.button("Biome finder", FormImage.Type.PATH, "textures/block/bamboo_mosaic.png");
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer fplayer = FloodgateApi.getInstance().getPlayer(this.uuid);
        fplayer.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player == null) {
            return;
        }
        TARDISCircuitChecker tcc = null;
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
            tcc = new TARDISCircuitChecker(this.plugin, this.id);
            tcc.getCircuits();
        }
        if (tcc != null && !tcc.hasTelepathic()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TELEPATHIC_CIRCUIT");
            return;
        }
        String label = response.clickedButton().text();
        if (!label.equals("Toggle telepathic circuit") && this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(this.uuid.toString(), SystemTree.TELEPATHIC_CIRCUIT)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Telepathic Circuit");
            return;
        }
        switch (label) {
            case "Cave finder": {
                player.performCommand("tardistravel cave");
                break;
            }
            case "Structure finder": {
                new FloodgateStructuresForm(this.plugin, player.getUniqueId(), this.id).send();
                break;
            }
            case "Biome finder": {
                new FloodgateBiomesForm(this.plugin, player.getUniqueId(), this.id).send();
                break;
            }
            default: {
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
                int b = rsp.resultSet() && rsp.isTelepathyOn() ? 0 : 1;
                HashMap<String, Object> set = new HashMap<String, Object>();
                HashMap<String, Object> whereu = new HashMap<String, Object>();
                whereu.put("uuid", player.getUniqueId().toString());
                set.put("telepathy_on", b);
                this.plugin.getQueryFactory().doUpdate("player_prefs", set, whereu);
                this.plugin.getMessenger().announceRepeater(player, "Telepathic Circuit " + (b == 1 ? "ON" : "OFF"));
            }
        }
    }
}

