/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitDamager;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonFrame;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateChameleonPresetForm;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateChameleonCircuitForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final int id;
    private final ChameleonPreset preset;

    public FloodgateChameleonCircuitForm(TARDIS plugin, UUID uuid, int id, ChameleonPreset preset) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
        this.preset = preset;
    }

    public void send() {
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title("TARDIS Chameleon Circuit")).button("Apply", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/apply_button.png").button("Chameleon Circuit", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/chameleon_button.png").button("Adaptive Biome", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/chameleon/adapt_button.png").button("Adaptive Block", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/chameleon/adapt_button.png").button("Invisible", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/invisible_button.png").button("Shorted out", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/chameleon/shorted_button.png").button("Construct", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/chameleon/construct_button.png").button("Lock", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/chameleon/lock_button.png").validResultHandler(this::handleResponse)).build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        String label = response.clickedButton().text();
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        HashMap<String, Object> set = new HashMap<String, Object>();
        HashMap<String, Object> wherec = new HashMap<String, Object>();
        wherec.put("tardis_id", this.id);
        TARDISChameleonFrame tcf = new TARDISChameleonFrame();
        HashMap<String, Object> whereh = new HashMap<String, Object>();
        whereh.put("tardis_id", this.id);
        whereh.put("type", Control.CHAMELEON.getId());
        ResultSetControls rsc = new ResultSetControls(this.plugin, whereh, true);
        boolean hasChameleonSign = rsc.resultSet();
        HashMap<String, Object> wheref = new HashMap<String, Object>();
        wheref.put("tardis_id", this.id);
        wheref.put("type", Control.FRAME.getId());
        ResultSetControls rsf = new ResultSetControls(this.plugin, wheref, false);
        boolean hasFrame = rsf.resultSet();
        switch (label) {
            case "Apply": {
                player.performCommand("tardis rebuild");
                if (!this.plugin.getConfig().getBoolean("circuits.damage") || this.plugin.getConfig().getInt("circuits.uses.chameleon") <= 0) break;
                TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, this.id);
                tcc.getCircuits();
                int uses_left = tcc.getChameleonUses();
                new TARDISCircuitDamager(this.plugin, DiskCircuit.CHAMELEON, uses_left, this.id, player).damage();
                break;
            }
            case "Chameleon Circuit": {
                set.put("adapti_on", 0);
                set.put("chameleon_preset", "FACTORY");
                if (hasChameleonSign) {
                    this.updateChameleonSign(rsc.getData(), "FACTORY", player);
                }
                if (hasFrame) {
                    tcf.updateChameleonFrame(ChameleonPreset.FACTORY, rsf.getLocation());
                }
                this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "CHAM_SET", "Factory Fresh", this.plugin);
                break;
            }
            case "Adaptive Biome": 
            case "Adaptive Block": {
                ChameleonPreset adaptive;
                ChameleonPreset chameleonPreset = adaptive = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? ChameleonPreset.SUBMERGED : ChameleonPreset.FACTORY;
                if (hasFrame) {
                    tcf.updateChameleonFrame(adaptive, rsf.getLocation());
                }
                set.put("chameleon_preset", adaptive.toString());
                set.put("adapti_on", label.equals("Adaptive Biome") ? 1 : 2);
                break;
            }
            case "Invisible": {
                TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, this.id);
                tcc.getCircuits();
                if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, false) && !tcc.hasInvisibility()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INVISIBILITY_MISSING");
                    break;
                }
                if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.invisibility") > 0) {
                    int uses_left = tcc.getInvisibilityUses();
                    new TARDISCircuitDamager(this.plugin, DiskCircuit.INVISIBILITY, uses_left, this.id, player).damage();
                }
                set.put("chameleon_preset", "INVISIBLE");
                if (hasChameleonSign) {
                    this.updateChameleonSign(rsc.getData(), "INVISIBLE", player);
                }
                if (hasFrame) {
                    tcf.updateChameleonFrame(ChameleonPreset.INVISIBLE, rsf.getLocation());
                }
                this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "CHAM_SET", "Invisibility", this.plugin);
                break;
            }
            case "Shorted out": {
                new FloodgateChameleonPresetForm(this.plugin, this.uuid).send();
                break;
            }
            case "Construct": {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONSTRUCT_USE_SHELL");
                break;
            }
            case "Lock": {
                if (this.isBiomeAdaptive(this.id)) {
                    Biome biome;
                    ChameleonPreset which;
                    ResultSetCurrentFromId rscl = new ResultSetCurrentFromId(this.plugin, this.id);
                    if (!rscl.resultSet() || (which = this.getAdaption(biome = rscl.getCurrent().location().getBlock().getBiome())) == null) break;
                    set.put("adapti_on", 0);
                    set.put("chameleon_preset", which.toString());
                    if (hasFrame) {
                        tcf.updateChameleonFrame(which, rsf.getLocation());
                    }
                    this.updateChameleonSign(rsc.getData(), which.toString(), player);
                    this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "CHAM_SET", which.getDisplayName(), this.plugin);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_LOCK");
                break;
            }
        }
        if (!set.isEmpty()) {
            this.plugin.getQueryFactory().doUpdate("tardis", set, wherec);
        }
    }

    private void updateChameleonSign(ArrayList<HashMap<String, String>> map, String preset, Player player) {
        for (HashMap<String, String> entry : map) {
            TARDISStaticUtils.setSign(entry.get("location"), 3, preset, player);
        }
    }

    private boolean isBiomeAdaptive(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        return rs.resultSet() && rs.getTardis().getAdaption() == Adaption.BIOME;
    }

    private ChameleonPreset getAdaption(Biome biome) {
        try {
            return ChameleonPreset.valueOf(this.plugin.getAdaptiveConfig().getString(biome.getKey().getKey().toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

