/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.enumeration;

import java.util.HashMap;

public enum SpaceTimeThrottle {
    NORMAL(4, 520L, 20, 11, 1.0f),
    FASTER(3, 400L, 16, 9, 1.5f),
    RAPID(2, 255L, 12, 7, 2.0f),
    WARP(1, 175L, 8, 5, 3.0f),
    REBUILD(0, 112L, 4, -1, 1.0f),
    JUNK(-1, 600L, 25, -1, 1.0f);

    private static final HashMap<Integer, SpaceTimeThrottle> BY_DELAY;
    private final int delay;
    private final long flightTime;
    private final int loops;
    private final int rescue;
    private final float artronMultiplier;

    private SpaceTimeThrottle(int delay, long flightTime, int loops, int rescue, float artronMultiplier) {
        this.delay = delay;
        this.flightTime = flightTime;
        this.loops = loops;
        this.rescue = rescue;
        this.artronMultiplier = artronMultiplier;
    }

    public static HashMap<Integer, SpaceTimeThrottle> getByDelay() {
        return BY_DELAY;
    }

    public int getDelay() {
        return this.delay;
    }

    public long getFlightTime() {
        return this.flightTime;
    }

    public int getLoops() {
        return this.loops;
    }

    public int getRescue() {
        return this.rescue;
    }

    public float getArtronMultiplier() {
        return this.artronMultiplier;
    }

    static {
        BY_DELAY = new HashMap();
        for (SpaceTimeThrottle spt : SpaceTimeThrottle.values()) {
            BY_DELAY.put(spt.delay, spt);
        }
    }
}

