/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.destroyers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISDestructionEvent;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoorBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGravity;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.database.tool.Table;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISExterminator {
    private final TARDIS plugin;

    public TARDISExterminator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static boolean deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    TARDISExterminator.deleteFolder(f);
                    continue;
                }
                if (f.delete()) continue;
                TARDIS.plugin.debug("Could not delete file");
            }
        }
        folder.delete();
        return true;
    }

    boolean pruneExterminate(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        try {
            if (rs.resultSet()) {
                ResultSetDoorBlocks rsdb;
                Tardis tardis = rs.getTardis();
                boolean hid = tardis.isHidden();
                String chunkLoc = tardis.getChunk();
                String owner = tardis.getOwner();
                UUID uuid = tardis.getUuid();
                int tips = tardis.getTIPS();
                boolean hasZero = !tardis.getZero().isEmpty();
                Schematic schm = tardis.getSchematic();
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    return false;
                }
                Current current = rsc.getCurrent();
                DestroyData dd = new DestroyData();
                dd.setDirection(current.direction());
                dd.setLocation(current.location());
                dd.setPlayer(this.plugin.getServer().getOfflinePlayer(uuid));
                dd.setHide(false);
                dd.setOutside(false);
                dd.setSubmarine(current.submarine());
                dd.setTardisID(id);
                dd.setThrottle(SpaceTimeThrottle.REBUILD);
                if (!hid) {
                    this.plugin.getPresetDestroyer().destroyPreset(dd);
                }
                if ((rsdb = new ResultSetDoorBlocks(this.plugin, id)).resultSet()) {
                    this.plugin.getTrackerKeeper().getPortals().remove(rsdb.getInnerBlock().getLocation());
                }
                this.cleanHashMaps(id);
                World cw = TARDISStaticLocationGetters.getWorldFromSplitString(chunkLoc);
                if (cw == null) {
                    this.plugin.debug("The server could not find the TARDIS world, has it been deleted?");
                    return false;
                }
                if (!cw.getName().toUpperCase(Locale.ROOT).contains("TARDIS_WORLD_")) {
                    this.plugin.getInteriorDestroyer().destroyInner(schm, id, cw, tips);
                }
                this.cleanWorlds(cw, owner);
                this.removeZeroRoom(tips, hasZero);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.cleanDatabase(id), 40L);
                return true;
            }
        }
        catch (Exception e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "TARDIS exterminate by id error: " + String.valueOf(e));
            return false;
        }
        return true;
    }

    public boolean playerExterminate(Player player) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            World cw;
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            HashMap<String, Object> travid = new HashMap<String, Object>();
            travid.put("tardis_id", id);
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, travid, true);
            if (rst.resultSet()) {
                for (UUID uuid : rst.getData()) {
                    Player p = this.plugin.getServer().getPlayer(uuid);
                    if (p == null || !p.isOnline()) continue;
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_NO_DELETE");
                    return false;
                }
            }
            String owner = tardis.getOwner();
            String chunkLoc = tardis.getChunk();
            int tips = tardis.getTIPS();
            boolean hasZero = !tardis.getZero().isEmpty();
            Schematic schm = tardis.getSchematic();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return false;
            }
            Current current = rsc.getCurrent();
            DestroyData dd = new DestroyData();
            dd.setDirection(current.direction());
            dd.setLocation(current.location());
            dd.setPlayer((OfflinePlayer)player);
            dd.setHide(false);
            dd.setOutside(false);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getPM().callEvent((Event)new TARDISDestructionEvent(player, current.location(), owner));
            if (!tardis.isHidden()) {
                this.plugin.getPresetDestroyer().destroyPreset(dd);
            }
            if ((cw = TARDISStaticLocationGetters.getWorldFromSplitString(chunkLoc)) == null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_DELETED");
                return true;
            }
            if (!cw.getName().toUpperCase(Locale.ROOT).contains("TARDIS_WORLD_")) {
                this.plugin.getInteriorDestroyer().destroyInner(schm, id, cw, tips);
            }
            this.cleanHashMaps(id);
            this.cleanWorlds(cw, owner);
            this.removeZeroRoom(tips, hasZero);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.cleanDatabase(id);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_EXTERMINATED");
            }, 40L);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXTERMINATE_NONE");
        }
        return true;
    }

    public void cleanHashMaps(int id) {
        HashMap<String, Object> whereb = new HashMap<String, Object>();
        whereb.put("tardis_id", id);
        ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, whereb, true);
        rsb.resultSetAsync((hasResult, resultSetBlocks) -> {
            if (hasResult) {
                resultSetBlocks.getData().forEach(rp -> this.plugin.getGeneralKeeper().getProtectBlockMap().remove(rp.getStrLocation()));
            }
        });
        HashMap<String, Object> whereg = new HashMap<String, Object>();
        whereg.put("tardis_id", id);
        ResultSetGravity rsg = new ResultSetGravity(this.plugin, whereg, true);
        if (rsg.resultSet()) {
            ArrayList<HashMap<String, String>> gdata = rsg.getData();
            block7: for (HashMap<String, String> gmap : gdata) {
                int direction = TARDISNumberParsers.parseInt(gmap.get("direction"));
                switch (direction) {
                    case 1: {
                        this.plugin.getGeneralKeeper().getGravityUpList().remove(gmap.get("location"));
                        continue block7;
                    }
                    case 2: {
                        this.plugin.getGeneralKeeper().getGravityNorthList().remove(gmap.get("location"));
                        continue block7;
                    }
                    case 3: {
                        this.plugin.getGeneralKeeper().getGravityWestList().remove(gmap.get("location"));
                        continue block7;
                    }
                    case 4: {
                        this.plugin.getGeneralKeeper().getGravitySouthList().remove(gmap.get("location"));
                        continue block7;
                    }
                    case 5: {
                        this.plugin.getGeneralKeeper().getGravityEastList().remove(gmap.get("location"));
                        continue block7;
                    }
                }
                this.plugin.getGeneralKeeper().getGravityDownList().remove(gmap.get("location"));
            }
        }
    }

    public void cleanDatabase(int id) {
        for (Table table : Table.values()) {
            if (!table.shouldClean()) continue;
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            this.plugin.getQueryFactory().doDelete(table.toString(), where);
        }
    }

    private void cleanWorlds(World w, String owner) {
        if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
            this.plugin.getWorldGuardUtils().removeRegion(w, owner);
            this.plugin.getWorldGuardUtils().removeRoomRegion(w, owner, "renderer");
        }
        if (w.getName().toUpperCase(Locale.ROOT).contains("TARDIS_WORLD_")) {
            String name = w.getName();
            List players = w.getPlayers();
            Location spawn = ((World)this.plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
            players.forEach(p -> {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "WORLD_RESET");
                p.teleport(spawn);
            });
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + name + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE)) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "mv remove " + name);
            }
            if (this.plugin.getPM().isPluginEnabled("WorldBorder")) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "wb " + name + " clear");
            }
            this.plugin.getServer().unloadWorld(w, true);
            File world_folder = new File(String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + name + File.separator);
            if (!TARDISExterminator.deleteFolder(world_folder)) {
                this.plugin.debug("Could not delete world <" + name + ">");
            }
        }
    }

    private void removeZeroRoom(int slot, boolean hasZero) {
        if (slot != -1000001 && this.plugin.getConfig().getBoolean("allow.zero_room") && hasZero) {
            TARDISInteriorPostioning tips = new TARDISInteriorPostioning(this.plugin);
            TARDISTIPSData coords = tips.getTIPSData(slot);
            World w = this.plugin.getServer().getWorld("TARDIS_Zero_Room");
            if (w != null) {
                tips.reclaimZeroChunk(w, coords);
            }
        }
    }
}

