/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;

public class ResultSetCurrentWithPreset {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final String world;
    private final int x;
    private final int y;
    private final int z;
    private int id;
    private ChameleonPreset preset;
    private boolean sign = false;

    public ResultSetCurrentWithPreset(TARDIS plugin, String world, int x, int y, int z) {
        this.plugin = plugin;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT " + this.prefix + "tardis.tardis_id, " + this.prefix + "tardis.uuid, " + this.prefix + "tardis.chameleon_preset FROM " + this.prefix + "tardis, " + this.prefix + "current WHERE " + this.prefix + "current.world = ? AND " + this.prefix + "current.x = ? AND " + this.prefix + "current.y = ? AND " + this.prefix + "current.z = ? AND " + this.prefix + "tardis.tardis_id = " + this.prefix + "current.tardis_id";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, this.world);
            statement.setInt(2, this.x);
            statement.setInt(3, this.y);
            statement.setInt(4, this.z);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                this.id = rs.getInt("tardis_id");
                String p = rs.getString("chameleon_preset");
                if (p.startsWith("ITEM:")) {
                    this.preset = ChameleonPreset.ITEM;
                } else {
                    try {
                        this.preset = ChameleonPreset.valueOf(p);
                    }
                    catch (IllegalArgumentException e) {
                        this.preset = ChameleonPreset.FACTORY;
                    }
                }
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, rs.getString("uuid"));
                if (rsp.resultSet()) {
                    this.sign = rsp.isSignOn();
                }
                boolean bl = true;
                return bl;
            }
            boolean p = false;
            return p;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for current vehicle table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing current vehicle table! " + e.getMessage());
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public ChameleonPreset getPreset() {
        return this.preset;
    }

    public boolean hasSign() {
        return this.sign;
    }
}

