/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISEmergencyRelocation;
import me.eccentric_nz.TARDIS.control.actions.ExileAction;
import me.eccentric_nz.TARDIS.control.actions.RandomDestinationAction;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRandomInteractions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRepeaters;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISRandomButton {
    private final TARDIS plugin;
    private final Player player;
    private final int id;
    private final int level;
    private final int secondary;
    private final String comps;
    private final UUID ownerUUID;

    public TARDISRandomButton(TARDIS plugin, Player player, int id, int level, int secondary, String comps, UUID ownerUUID) {
        this.plugin = plugin;
        this.player = player;
        this.id = id;
        this.level = level;
        this.secondary = secondary;
        this.comps = comps;
        this.ownerUUID = ownerUUID;
    }

    public void clickButton() {
        int cost = this.plugin.getArtronConfig().getInt("random");
        if (this.level < cost) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
            return;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
        if (!rsc.resultSet()) {
            new TARDISEmergencyRelocation(this.plugin).relocate(this.id, this.player);
            return;
        }
        Current current = rsc.getCurrent();
        COMPASS direction = current.direction();
        if (TARDISPermission.hasPermission(this.player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
            new ExileAction(this.plugin).getExile(this.player, this.id, direction);
        } else {
            ResultSetRepeaters rsr = new ResultSetRepeaters(this.plugin, this.id, this.secondary);
            if (rsr.resultSet()) {
                ResultSetRandomInteractions rsri;
                int[] repeaters = rsr.getRepeaters();
                if (repeaters[0] == -1 && (rsri = new ResultSetRandomInteractions(this.plugin, this.id)).resultSet()) {
                    repeaters = rsri.getStates();
                }
                new RandomDestinationAction(this.plugin).getRandomDestination(this.player, this.id, repeaters, current, direction, this.level, cost, this.comps, this.ownerUUID);
            }
        }
    }
}

