/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.wiki;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.dev.wiki.PageBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;

public class CustomPageBuilder
extends PageBuilder {
    private final TARDIS plugin;

    public CustomPageBuilder(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public boolean compile() {
        for (TARDISDisplayItem tdi : TARDISDisplayItemRegistry.values()) {
            if (tdi.getCraftMaterial() == null) continue;
            this.plugin.debug(tdi.toString());
            String data = this.formatCustom(tdi);
            if (data.isEmpty()) continue;
            this.save(TARDISStringUtils.toDashedLowercase(tdi.toString()), data);
        }
        return true;
    }

    private String formatCustom(TARDISDisplayItem tdi) {
        String item = TARDISStringUtils.capitalise(tdi.toString());
        String mat = TARDISStringUtils.toDashedLowercase(tdi.getCraftMaterial().toString());
        String cap = TARDISStringUtils.capitalise(tdi.getCraftMaterial().toString());
        String easyIngredients = "[" + cap + "](" + cap.replaceAll(" ", "_") + ")<br/>[Glass Pane](https://minecraft.wiki/w/Glass_Pane)";
        String hardIngredients = "[" + cap + "](" + cap.replaceAll(" ", "_") + ")<br/>[Glass ](https://minecraft.wiki/w/Glass)";
        String crafting = TARDISStringUtils.toDashedLowercase(tdi.toString());
        String easyTable = "['glass-pane','glass-pane','glass-pane','glass-pane','" + mat + "','glass-pane','glass-pane','glass-pane','glass-pane','" + crafting + "']";
        String hardTable = "['glass','glass','glass','glass','" + mat + "','glass','glass','glass','glass','" + crafting + "']";
        String PAGE = "---\nlayout: default\ntitle: %s\n---\n\nimport Recipe from \"@site/src/components/Recipe\";\n\n%s\n===================\n\nA %s custom block.\n\n## Crafting\n\n`/trecipe %s`\n\n| Ingredients | Crafting recipe | Difficulty |\n| ----------- | --------------- | ---------- |\n| %s | <Recipe icons={%s} /> | easy |\n| %s | <Recipe icons={%s} /> | hard |\n\n";
        return String.format(PAGE, item, item, item, crafting, easyIngredients, easyTable, hardIngredients, hardTable);
    }
}

