/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.ARS.ARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISRoomGrowEvent;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomData;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomRunnable;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

class TARDISARSRunnable
implements Runnable {
    private final TARDIS plugin;
    private final TARDISARSSlot slot;
    private final ARS room;
    private final Player p;
    private final int tardis_id;

    TARDISARSRunnable(TARDIS plugin, TARDISARSSlot slot, ARS room, Player p, int tardis_id) {
        this.plugin = plugin;
        this.slot = slot;
        this.room = room;
        this.p = p;
        this.tardis_id = tardis_id;
    }

    @Override
    public void run() {
        String whichroom = this.room.getConfigPath();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", this.p.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Material floor_type;
            Material wall_type;
            Tardis tardis = rs.getTardis();
            this.plugin.getTrackerKeeper().getIsGrowingRooms().add(tardis.getTardisId());
            World w = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.p.getUniqueId().toString());
            TARDISRoomData roomData = new TARDISRoomData();
            roomData.setTardis_id(tardis.getTardisId());
            if (rsp.resultSet()) {
                wall_type = Material.getMaterial((String)rsp.getWall());
                floor_type = Material.getMaterial((String)rsp.getFloor());
            } else {
                wall_type = Material.ORANGE_WOOL;
                floor_type = Material.LIGHT_GRAY_WOOL;
            }
            if (this.room.getConfigPath().equals("SURGERY")) {
                wall_type = Material.WHITE_CONCRETE;
                floor_type = Material.LIGHT_GRAY_CONCRETE;
            }
            roomData.setMiddleType(wall_type);
            roomData.setFloorType(floor_type);
            Location l = new Location(w, (double)this.slot.getX(), (double)this.slot.getY(), (double)this.slot.getZ());
            roomData.setDirection(COMPASS.SOUTH);
            JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "rooms", whichroom.toLowerCase(Locale.ROOT), this.plugin.getRoomsConfig().getBoolean("rooms." + whichroom + ".user"));
            if (obj != null) {
                l.setY(l.getY() + (double)this.room.getOffset());
                roomData.setLocation(l);
                roomData.setRoom(whichroom);
                roomData.setSchematic(obj);
                long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
                this.plugin.getPM().callEvent((Event)new TARDISRoomGrowEvent(this.p, tardis, this.slot, roomData));
                TARDISRoomRunnable runnable = new TARDISRoomRunnable(this.plugin, roomData, this.p.getUniqueId());
                int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, delay, delay);
                runnable.setTask(taskID);
                this.plugin.getTrackerKeeper().getRoomTasks().put(taskID, roomData);
                if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks")) {
                    HashMap<String, Integer> roomBlockCounts = this.getRoomBlockCounts(whichroom, this.p.getUniqueId().toString());
                    roomBlockCounts.forEach((key, value) -> {
                        HashMap<String, Object> wherec = new HashMap<String, Object>();
                        wherec.put("tardis_id", this.tardis_id);
                        wherec.put("block_data", key);
                        this.plugin.getQueryFactory().alterCondenserBlockCount((int)value, wherec);
                    });
                }
                int amount = this.plugin.getRoomsConfig().getInt("rooms." + whichroom + ".cost");
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("uuid", this.p.getUniqueId().toString());
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, set, this.p);
                if (this.p.isOnline()) {
                    this.plugin.getMessenger().send((CommandSender)this.p, TardisModule.TARDIS, "ARS_CANCEL", whichroom, String.format("%d", taskID));
                }
            }
        }
    }

    private HashMap<String, Integer> getRoomBlockCounts(String room, String uuid) {
        HashMap<String, Integer> blockIDCount = new HashMap<String, Integer>();
        HashMap<String, Integer> roomBlocks = this.plugin.getBuildKeeper().getRoomBlockCounts().get(room);
        String wall = "ORANGE_WOOL";
        String floor = "LIGHT_GRAY_WOOL";
        boolean hasPrefs = false;
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
        if (rsp.resultSet()) {
            hasPrefs = true;
            wall = rsp.getWall();
            floor = rsp.getFloor();
        }
        for (Map.Entry<String, Integer> entry : roomBlocks.entrySet()) {
            int required;
            String bid = entry.getKey();
            String bdata = hasPrefs && (bid.equals("ORANGE_WOOL") || bid.equals("LIGHT_GRAY_WOOL")) ? (bid.equals("ORANGE_WOOL") ? wall : floor) : bid;
            int tmp = Math.round((float)entry.getValue().intValue() / 100.0f * (float)this.plugin.getConfig().getInt("growth.rooms_condenser_percent"));
            int n = required = tmp > 0 ? tmp : 1;
            if (blockIDCount.containsKey(bdata)) {
                blockIDCount.put(bdata, blockIDCount.get(bdata) + required);
                continue;
            }
            blockIDCount.put(bdata, required);
        }
        return blockIDCount;
    }
}

