/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.model;

import java.util.Objects;
import net.raphimc.noteblocklib.model.instrument.Instrument;

public class Note {
    private Instrument instrument;
    private float midiKey;
    private float volume = 1.0f;
    private float panning = 0.0f;

    public boolean isOutsideMinecraftOctaveRange() {
        return this.midiKey < 54.0f || this.midiKey > 78.0f;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public Note setInstrument(Instrument instrument) {
        this.instrument = instrument;
        return this;
    }

    public float getMidiKey() {
        return this.midiKey;
    }

    public Note setMidiKey(float midiKey) {
        this.midiKey = midiKey;
        return this;
    }

    public int getMcKey() {
        return Math.round(this.midiKey - 54.0f);
    }

    public Note setMcKey(int mcKey) {
        this.midiKey = mcKey + 54;
        return this;
    }

    public int getNbsKey() {
        return Math.round(this.midiKey - 21.0f);
    }

    public Note setNbsKey(float nbsKey) {
        this.midiKey = nbsKey + 21.0f;
        return this;
    }

    public float getFractionalKeyPart() {
        int roundedKey = Math.round(this.midiKey);
        return this.midiKey - (float)roundedKey;
    }

    public float getPitch() {
        return (float)Math.pow(2.0, (double)(this.midiKey - 66.0f) / 12.0);
    }

    public Note setPitch(float pitch) {
        this.midiKey = (float)(66.0 + 12.0 * Math.log(pitch) / Math.log(2.0));
        return this;
    }

    public float getVolume() {
        return this.volume;
    }

    public Note setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public float getPanning() {
        return this.panning;
    }

    public Note setPanning(float panning) {
        this.panning = panning;
        return this;
    }

    public Note copy() {
        Note copyNote = new Note();
        copyNote.instrument = this.instrument.copy();
        copyNote.midiKey = this.midiKey;
        copyNote.volume = this.volume;
        copyNote.panning = this.panning;
        return copyNote;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return this.midiKey == note.midiKey && Float.compare(this.volume, note.volume) == 0 && Float.compare(this.panning, note.panning) == 0 && Objects.equals(this.instrument, note.instrument);
    }

    public int hashCode() {
        return Objects.hash(this.instrument, Float.valueOf(this.midiKey), Float.valueOf(this.volume), Float.valueOf(this.panning));
    }
}

