/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.util.network;

import com.zigythebird.playeranim.lib.mochafloats.util.network.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ProtocolUtils {
    public static <T> List<T> readList(ByteBuf buf, Function<ByteBuf, T> reader) {
        int count = VarIntUtils.readVarInt(buf);
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            list.add(reader.apply(buf));
        }
        return list;
    }

    public static <T> void writeList(ByteBuf buf, List<T> list, BiConsumer<T, ByteBuf> writer) {
        VarIntUtils.writeVarInt(buf, list.size());
        for (T entry : list) {
            writer.accept(entry, buf);
        }
    }

    public static void writeEnum(Enum<?> enumValue, ByteBuf buf) {
        buf.writeByte(enumValue.ordinal());
    }

    public static <T> T readEnum(Class<T> enumClass, ByteBuf buf) {
        short ordinal = buf.readUnsignedByte();
        T[] constants = enumClass.getEnumConstants();
        if (ordinal < 0 || ordinal >= constants.length) {
            return constants[0];
        }
        return constants[ordinal];
    }

    @Nullable
    public static String readString(ByteBuf buf) {
        int length = VarIntUtils.readVarInt(buf);
        if (length <= 0) {
            return null;
        }
        String str = buf.toString(buf.readerIndex(), length, StandardCharsets.UTF_8);
        buf.skipBytes(length);
        return str;
    }

    public static void writeString(ByteBuf buf, @Nullable String str) {
        if (str == null) {
            VarIntUtils.writeVarInt(buf, 0);
            return;
        }
        int size = ByteBufUtil.utf8Bytes((CharSequence)str);
        VarIntUtils.writeVarInt(buf, size);
        buf.writeCharSequence((CharSequence)str, StandardCharsets.UTF_8);
    }
}

