/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime;

import com.zigythebird.playeranim.lib.mochafloats.runtime.Scope;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectProperty;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import com.zigythebird.playeranim.lib.mochafloats.util.CaseInsensitiveStringHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScopeImpl
implements Scope {
    private final Map<String, ObjectProperty> bindings = new CaseInsensitiveStringHashMap<ObjectProperty>();
    private boolean readOnly;

    ScopeImpl() {
    }

    @Override
    @Nullable
    public ObjectProperty getProperty(@NotNull String name) {
        return this.bindings.get(name);
    }

    @Override
    @NotNull
    public Scope copy() {
        ScopeImpl copy = new ScopeImpl();
        copy.bindings.putAll(this.bindings);
        return copy;
    }

    @Override
    public boolean set(@NotNull String name, @Nullable Value value) {
        if (this.readOnly) {
            return false;
        }
        if (value == null) {
            this.bindings.remove(name);
        } else {
            this.bindings.put(name, ObjectProperty.property(value, false));
        }
        return true;
    }

    @Override
    public void readOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    @NotNull
    public Map<String, ObjectProperty> entries() {
        return this.bindings;
    }

    static final class BuilderImpl
    implements Scope.Builder {
        private final Map<String, ObjectProperty> properties = new CaseInsensitiveStringHashMap<ObjectProperty>();

        BuilderImpl() {
        }

        @Override
        public Scope.Builder set(@NotNull String name, @NotNull Value value) {
            this.properties.put(name, ObjectProperty.property(value, true));
            return this;
        }

        @Override
        public Scope build() {
            ScopeImpl impl = new ScopeImpl();
            impl.bindings.putAll(this.properties);
            return impl;
        }
    }
}

