/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.lexer;

import com.zigythebird.playeranim.lib.mochafloats.lexer.Characters;
import com.zigythebird.playeranim.lib.mochafloats.lexer.Cursor;
import com.zigythebird.playeranim.lib.mochafloats.lexer.MolangLexer;
import com.zigythebird.playeranim.lib.mochafloats.lexer.Token;
import com.zigythebird.playeranim.lib.mochafloats.lexer.TokenKind;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class MolangLexerImpl
implements MolangLexer {
    private final Reader reader;
    private final Cursor cursor = new Cursor();
    private int next;
    private Token token = null;

    MolangLexerImpl(@NotNull Reader reader) throws IOException {
        this.reader = Objects.requireNonNull(reader, "reader");
        this.next = reader.read();
    }

    @Override
    @NotNull
    public Cursor cursor() {
        return this.cursor;
    }

    @Override
    @NotNull
    public Token current() {
        if (this.token == null) {
            throw new IllegalStateException("No current token, please call next() at least once");
        }
        return this.token;
    }

    @Override
    @NotNull
    public Token next() throws IOException {
        this.token = this.next0();
        return this.token;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @NotNull
    private Token next0() throws IOException {
        TokenKind tokenKind;
        int c = this.next;
        if (c == -1) {
            return new Token(TokenKind.EOF, null, this.cursor.index(), this.cursor.index() + 1);
        }
        while (c == 32 || c == 9 || c == 10 || c == 13) {
            c = this.read();
        }
        if (c == -1) {
            return new Token(TokenKind.EOF, null, this.cursor.index(), this.cursor.index() + 1);
        }
        int start = this.cursor.index();
        if (Character.isDigit(c)) {
            StringBuilder builder = new StringBuilder(8);
            builder.appendCodePoint(c);
            while (Character.isDigit(c = this.read())) {
                builder.appendCodePoint(c);
            }
            if (c == 46) {
                builder.append('.');
                while (Character.isDigit(c = this.read())) {
                    builder.appendCodePoint(c);
                }
            }
            if (c == 101 || c == 69) {
                builder.appendCodePoint(c);
                c = this.read();
                if (c == 43 || c == 45) {
                    builder.appendCodePoint(c);
                    c = this.read();
                }
                if (!Character.isDigit(c)) {
                    return new Token(TokenKind.ERROR, "Malformed floating point literal", start, this.cursor.index());
                }
                do {
                    builder.appendCodePoint(c);
                } while (Character.isDigit(c = this.read()));
            }
            return new Token(TokenKind.FLOAT, builder.toString(), start, this.cursor.index());
        }
        if (Characters.isValidForWordStart(c)) {
            StringBuilder builder = new StringBuilder();
            do {
                builder.appendCodePoint(c);
            } while (Characters.isValidForWordContinuation(c = this.read()));
            String word = builder.toString();
            TokenKind kind = switch (word.toLowerCase(Locale.ROOT)) {
                case "break" -> TokenKind.BREAK;
                case "continue" -> TokenKind.CONTINUE;
                case "return" -> TokenKind.RETURN;
                case "true" -> TokenKind.TRUE;
                case "false" -> TokenKind.FALSE;
                default -> TokenKind.IDENTIFIER;
            };
            return new Token(kind, kind == TokenKind.IDENTIFIER ? word : null, start, this.cursor.index());
        }
        if (c == 39) {
            StringBuilder value = new StringBuilder(16);
            while (true) {
                if ((c = this.read()) == -1) {
                    return new Token(TokenKind.ERROR, "Found end-of-file before closing quote", start, this.cursor.index());
                }
                if (c == 39) break;
                value.appendCodePoint(c);
            }
            this.read();
            return new Token(TokenKind.STRING, value.toString(), start, this.cursor.index());
        }
        Object value = null;
        int c1 = -2;
        switch (c) {
            case 33: {
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    tokenKind = TokenKind.BANGEQ;
                    break;
                }
                tokenKind = TokenKind.BANG;
                break;
            }
            case 38: {
                c1 = this.read();
                if (c1 == 38) {
                    this.read();
                    tokenKind = TokenKind.AMPAMP;
                    break;
                }
                tokenKind = TokenKind.ERROR;
                value = "Unexpected token '" + (char)c1 + "', expected '&' (Molang doesn't support bitwise operators)";
                break;
            }
            case 124: {
                c1 = this.read();
                if (c1 == 124) {
                    this.read();
                    tokenKind = TokenKind.BARBAR;
                    break;
                }
                tokenKind = TokenKind.ERROR;
                value = "Unexpected token '" + (char)c1 + "', expected '|' (Molang doesn't support bitwise operators)";
                break;
            }
            case 60: {
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    tokenKind = TokenKind.LTE;
                    break;
                }
                tokenKind = TokenKind.LT;
                break;
            }
            case 62: {
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    tokenKind = TokenKind.GTE;
                    break;
                }
                tokenKind = TokenKind.GT;
                break;
            }
            case 61: {
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    tokenKind = TokenKind.EQEQ;
                    break;
                }
                tokenKind = TokenKind.EQ;
                break;
            }
            case 45: {
                c1 = this.read();
                if (c1 == 62) {
                    this.read();
                    tokenKind = TokenKind.ARROW;
                    break;
                }
                tokenKind = TokenKind.SUB;
                break;
            }
            case 63: {
                c1 = this.read();
                if (c1 == 63) {
                    this.read();
                    tokenKind = TokenKind.QUESQUES;
                    break;
                }
                tokenKind = TokenKind.QUES;
                break;
            }
            case 47: {
                tokenKind = TokenKind.SLASH;
                break;
            }
            case 42: {
                tokenKind = TokenKind.STAR;
                break;
            }
            case 43: {
                tokenKind = TokenKind.PLUS;
                break;
            }
            case 44: {
                tokenKind = TokenKind.COMMA;
                break;
            }
            case 46: {
                tokenKind = TokenKind.DOT;
                break;
            }
            case 40: {
                tokenKind = TokenKind.LPAREN;
                break;
            }
            case 41: {
                tokenKind = TokenKind.RPAREN;
                break;
            }
            case 123: {
                tokenKind = TokenKind.LBRACE;
                break;
            }
            case 125: {
                tokenKind = TokenKind.RBRACE;
                break;
            }
            case 58: {
                tokenKind = TokenKind.COLON;
                break;
            }
            case 91: {
                tokenKind = TokenKind.LBRACKET;
                break;
            }
            case 93: {
                tokenKind = TokenKind.RBRACKET;
                break;
            }
            case 59: {
                tokenKind = TokenKind.SEMICOLON;
                break;
            }
            case 34: {
                tokenKind = TokenKind.ERROR;
                value = "Unexpected token '\"', expected single quote (') to start a string literal";
                break;
            }
            default: {
                tokenKind = TokenKind.ERROR;
                value = "Unexpected token '" + (char)c + "': invalid token";
            }
        }
        if (c1 == -2) {
            this.read();
        }
        return new Token(tokenKind, (String)value, start, this.cursor.index());
    }

    private int read() throws IOException {
        int c = this.reader.read();
        this.cursor.push(c);
        this.next = c;
        return c;
    }
}

