/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.bukkit.network;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.bukkit.BukkitWrapper;
import io.github.kosmx.emotes.bukkit.network.ServerSideEmotePlay;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.server.network.EmotePlayTracker;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Avatar;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BukkitNetworkInstance
extends AbstractNetworkInstance
implements IServerNetworkInstance {
    private static final BukkitWrapper PLUGIN = (BukkitWrapper)BukkitWrapper.getPlugin(BukkitWrapper.class);
    private final EmotePlayTracker emotePlayTracker = new EmotePlayTracker();
    protected final Avatar avatar;

    public BukkitNetworkInstance(Avatar avatar) {
        this.avatar = avatar;
    }

    @Override
    public EmotePlayTracker getEmoteTracker() {
        return this.emotePlayTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(EmotePacket packet, @Nullable UUID target) {
        Avatar avatar = this.avatar;
        if (!(avatar instanceof ServerPlayer)) {
            CommonData.LOGGER.error("Attempt to send a packet of an unsupported entity: {}!", (Object)this.avatar);
            return;
        }
        ServerPlayer player = (ServerPlayer)avatar;
        ByteBuf buf = Unpooled.buffer();
        try {
            packet.write(buf);
            player.getBukkitEntity().sendPluginMessage((Plugin)PLUGIN, BukkitWrapper.EMOTE_PACKET, MathHelper.readBytes(buf));
        }
        finally {
            buf.release();
        }
    }

    @Override
    public boolean isActive() {
        return this.avatar instanceof ServerPlayer;
    }

    @Override
    public void presenceResponse() {
        super.presenceResponse();
        ServerSideEmotePlay.getInstance().presenceResponse(this, this.trackPlayState());
    }
}

