/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime.value;

import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectProperty;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectPropertyImpl
implements ObjectProperty {
    private final Value value;
    private final boolean constant;

    ObjectPropertyImpl(@NotNull Value value, boolean constant) {
        this.value = Objects.requireNonNull(value, "value");
        this.constant = constant;
    }

    @Override
    @NotNull
    public Value value() {
        return this.value;
    }

    @Override
    public boolean constant() {
        return this.constant;
    }

    @NotNull
    public String toString() {
        return "ObjectProperty(" + String.valueOf(this.value) + "(" + (this.constant ? "constant" : "variable") + "))";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPropertyImpl that = (ObjectPropertyImpl)o;
        if (this.constant != that.constant) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.constant ? 1 : 0);
        return result;
    }
}

