/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.parser.ast;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.util.network.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class StringExpression
implements Expression {
    private final String value;

    public StringExpression(ByteBuf buf) {
        this(ProtocolUtils.readString(buf));
    }

    public StringExpression(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitString(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ProtocolUtils.writeString(buf, this.value());
    }

    public String toString() {
        return String.format("'%s'", this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringExpression that = (StringExpression)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

