/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.molang;

import com.google.gson.JsonElement;
import com.zigythebird.playeranim.lib.mochafloats.MochaEngine;
import com.zigythebird.playeranim.lib.mochafloats.parser.MolangParser;
import com.zigythebird.playeranim.lib.mochafloats.parser.ParseException;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.IsConstantExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.NumberValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import com.zigythebird.playeranimcore.PlayerAnimLib;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.event.MolangEvent;
import com.zigythebird.playeranimcore.molang.QueryBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class MolangLoader {
    private static final Consumer<ParseException> HANDLER = e -> PlayerAnimLib.LOGGER.warn("Failed to parse!", (Throwable)e);

    public static List<Expression> parseJson(boolean isForRotation, JsonElement element, Expression defaultValue) {
        List<Expression> expressions;
        try (MolangParser parser = MolangParser.parser(element.getAsString());){
            List<Expression> expressions1 = parser.parseAll();
            if (expressions1.size() == 1 && isForRotation && IsConstantExpression.test(expressions1.getFirst())) {
                expressions = new ArrayList<Expression>();
                expressions.add(FloatExpression.of(Math.toRadians(((FloatExpression)expressions1.getFirst()).value())));
            } else {
                expressions = expressions1;
            }
        }
        catch (IOException e) {
            PlayerAnimLib.LOGGER.error("Failed to compile molang '{}'!", (Object)element, (Object)e);
            if (defaultValue == null) {
                return null;
            }
            return Collections.singletonList(defaultValue);
        }
        return expressions;
    }

    public static MochaEngine<AnimationController> createNewEngine(AnimationController controller) {
        MochaEngine<AnimationController> engine = MochaEngine.createStandard(controller);
        engine.handleParseExceptions(HANDLER);
        engine.warnOnReflectiveFunctionUsage(true);
        QueryBinding<AnimationController> queryBinding = new QueryBinding<AnimationController>(controller);
        MolangLoader.setDoubleQuery(queryBinding, "anim_time", AnimationController::getAnimationTime);
        MolangLoader.setDoubleQuery(queryBinding, "controller_speed", AnimationController::getAnimationSpeed);
        MolangEvent.MOLANG_EVENT.invoker().registerMolangQueries(controller, engine, queryBinding);
        queryBinding.block();
        engine.scope().set("query", queryBinding);
        engine.scope().set("q", queryBinding);
        return engine;
    }

    public static MochaEngine<?> createNewEngine() {
        MochaEngine<?> engine = MochaEngine.createStandard();
        engine.handleParseExceptions(HANDLER);
        engine.warnOnReflectiveFunctionUsage(true);
        return engine;
    }

    public static boolean setDoubleQuery(ObjectValue binding, String name, ToDoubleFunction<AnimationController> value) {
        return MolangLoader.setControllerQuery(binding, name, controller -> NumberValue.of(value.applyAsDouble((AnimationController)controller)));
    }

    public static boolean setBoolQuery(ObjectValue binding, String name, Function<AnimationController, Boolean> value) {
        return MolangLoader.setControllerQuery(binding, name, controller -> Value.of((Boolean)value.apply((AnimationController)controller)));
    }

    public static boolean setControllerQuery(ObjectValue binding, String name, Function<AnimationController, Value> value) {
        return binding.set(name, (ctx, args) -> (Value)value.apply((AnimationController)ctx.entity()));
    }

    public static boolean isConstant(List<Expression> expressions) {
        return expressions.stream().anyMatch(IsConstantExpression::test);
    }
}

