/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp2;

import java.util.Arrays;
import java.util.List;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Layer;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Note;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Song;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.util.SongResampler;

public class McSp2Converter {
    private static final List<MinecraftInstrument> SUPPORTED_INSTRUMENTS = Arrays.asList(MinecraftInstrument.HARP, MinecraftInstrument.BASS, MinecraftInstrument.BASS_DRUM, MinecraftInstrument.SNARE, MinecraftInstrument.HAT);

    public static McSp2Song createSong(Song song) {
        song = song.copy();
        SongResampler.changeTickSpeed(song, Math.max(1, Math.min(20, Math.round(song.getTempoEvents().get(0)))));
        McSp2Song newSong = new McSp2Song();
        newSong.copyGeneralData(song);
        newSong.setTempo((int)song.getTempoEvents().get(0));
        for (int tick : song.getNotes().getTicks()) {
            List<Note> notes = song.getNotes().get(tick);
            for (int i = 0; i < notes.size(); ++i) {
                Note note = notes.get(i);
                if (!(note.getInstrument() instanceof MinecraftInstrument) || !SUPPORTED_INSTRUMENTS.contains((MinecraftInstrument)note.getInstrument()) || !(note.getVolume() > 0.0f)) continue;
                McSp2Note mcSp2Note = new McSp2Note();
                mcSp2Note.setInstrument(((MinecraftInstrument)note.getInstrument()).nbsId());
                mcSp2Note.setKey((byte)Math.max(0, Math.min(24, note.getMcKey())));
                McSp2Layer mcSp2Layer = newSong.getLayers().computeIfAbsent(i, k -> new McSp2Layer());
                mcSp2Layer.getNotes().put(tick, mcSp2Note);
            }
        }
        if (song instanceof McSp2Song) {
            McSp2Song mcSp2Song = (McSp2Song)song;
            newSong.setAutoSaveInterval(mcSp2Song.getAutoSaveInterval());
            newSong.setAutoSaveInterval((byte)mcSp2Song.getAutoSaveInterval());
            newSong.setMinutesSpent(mcSp2Song.getMinutesSpent());
            newSong.setLeftClicks(mcSp2Song.getLeftClicks());
            newSong.setRightClicks(mcSp2Song.getRightClicks());
            newSong.setNoteBlocksAdded(mcSp2Song.getNoteBlocksAdded());
            newSong.setNoteBlocksRemoved(mcSp2Song.getNoteBlocksRemoved());
        } else if (song instanceof NbsSong) {
            NbsSong nbsSong = (NbsSong)song;
            newSong.setAutoSaveInterval(nbsSong.isAutoSave() ? nbsSong.getAutoSaveInterval() : (byte)0);
            newSong.setMinutesSpent(nbsSong.getMinutesSpent());
            newSong.setLeftClicks(nbsSong.getLeftClicks());
            newSong.setRightClicks(nbsSong.getRightClicks());
            newSong.setNoteBlocksAdded(nbsSong.getNoteBlocksAdded());
            newSong.setNoteBlocksRemoved(nbsSong.getNoteBlocksRemoved());
        }
        return newSong;
    }
}

