/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.futureclient.FutureClientIo;
import net.raphimc.noteblocklib.format.futureclient.model.FutureClientSong;
import net.raphimc.noteblocklib.format.mcsp.McSpIo;
import net.raphimc.noteblocklib.format.mcsp.model.McSpSong;
import net.raphimc.noteblocklib.format.mcsp2.McSp2Converter;
import net.raphimc.noteblocklib.format.mcsp2.McSp2Io;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Song;
import net.raphimc.noteblocklib.format.midi.MidiIo;
import net.raphimc.noteblocklib.format.midi.model.MidiSong;
import net.raphimc.noteblocklib.format.nbs.NbsConverter;
import net.raphimc.noteblocklib.format.nbs.NbsIo;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.format.txt.TxtConverter;
import net.raphimc.noteblocklib.format.txt.TxtIo;
import net.raphimc.noteblocklib.format.txt.model.TxtSong;
import net.raphimc.noteblocklib.model.Song;

public class NoteBlockLib {
    public static Song readSong(File file) throws Exception {
        return NoteBlockLib.readSong(file.toPath());
    }

    public static Song readSong(Path path) throws Exception {
        return NoteBlockLib.readSong(path, NoteBlockLib.getFormat(path));
    }

    public static Song readSong(Path path, SongFormat format) throws Exception {
        return NoteBlockLib.readSong(Files.newInputStream(path, new OpenOption[0]), format, path.getFileName().toString());
    }

    public static Song readSong(byte[] bytes, SongFormat format) throws Exception {
        return NoteBlockLib.readSong(new ByteArrayInputStream(bytes), format);
    }

    public static Song readSong(InputStream is, SongFormat format) throws Exception {
        return NoteBlockLib.readSong(is, format, null);
    }

    public static Song readSong(InputStream is, SongFormat format, String fileName) throws Exception {
        try {
            switch (format) {
                case NBS: {
                    NbsSong nbsSong = NbsIo.readSong(is, fileName);
                    return nbsSong;
                }
                case MCSP: {
                    McSpSong mcSpSong = McSpIo.readSong(is, fileName);
                    return mcSpSong;
                }
                case MCSP2: {
                    McSp2Song mcSp2Song = McSp2Io.readSong(is, fileName);
                    return mcSp2Song;
                }
                case TXT: {
                    TxtSong txtSong = TxtIo.readSong(is, fileName);
                    return txtSong;
                }
                case FUTURE_CLIENT: {
                    FutureClientSong futureClientSong = FutureClientIo.readSong(is, fileName);
                    return futureClientSong;
                }
                case MIDI: {
                    MidiSong midiSong = MidiIo.readSong(is, fileName);
                    return midiSong;
                }
            }
            try {
                throw new IllegalStateException("Unknown format");
            }
            catch (Throwable e) {
                throw new Exception("Failed to read song", e);
            }
        }
        finally {
            is.close();
        }
    }

    public static void writeSong(Song song, File file) throws Exception {
        NoteBlockLib.writeSong(song, file.toPath());
    }

    public static void writeSong(Song song, Path path) throws Exception {
        NoteBlockLib.writeSong(song, Files.newOutputStream(path, new OpenOption[0]));
    }

    public static void writeSong(Song song, OutputStream os) throws Exception {
        block8: {
            try {
                if (song instanceof NbsSong) {
                    NbsIo.writeSong((NbsSong)song, os);
                    break block8;
                }
                if (song instanceof McSp2Song) {
                    McSp2Io.writeSong((McSp2Song)song, os);
                    break block8;
                }
                if (song instanceof TxtSong) {
                    TxtIo.writeSong((TxtSong)song, os);
                    break block8;
                }
                throw new Exception("Unsupported song format for writing: " + song.getClass().getSimpleName());
            }
            catch (Throwable e) {
                throw new Exception("Failed to write song", e);
            }
            finally {
                os.close();
            }
        }
    }

    public static Song convertSong(Song song, SongFormat targetFormat) {
        switch (targetFormat) {
            case NBS: {
                return NbsConverter.createSong(song);
            }
            case MCSP2: {
                return McSp2Converter.createSong(song);
            }
            case TXT: {
                return TxtConverter.createSong(song);
            }
        }
        throw new IllegalStateException("Unsupported target format: " + (Object)((Object)targetFormat));
    }

    public static SongFormat getFormat(Path path) {
        return SongFormat.getByExtension(com.google.common.io.Files.getFileExtension((String)path.getFileName().toString()));
    }
}

