/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.parser.ast;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.util.network.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdentifierExpression
implements Expression {
    private final String name;

    public IdentifierExpression(ByteBuf buf) {
        this(ProtocolUtils.readString(buf));
    }

    public IdentifierExpression(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        this.name = name.toLowerCase();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitIdentifier(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ProtocolUtils.writeString(buf, this.name());
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierExpression that = (IdentifierExpression)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

