/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.txt;

import java.util.ArrayList;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.txt.model.TxtNote;
import net.raphimc.noteblocklib.format.txt.model.TxtSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.util.SongResampler;

public class TxtConverter {
    public static TxtSong createSong(Song song) {
        song = song.copy();
        SongResampler.changeTickSpeed(song, 20.0f);
        TxtSong newSong = new TxtSong();
        newSong.copyGeneralData(song);
        for (int tick : song.getNotes().getTicks()) {
            for (Note note : song.getNotes().get(tick)) {
                if (!(note.getInstrument() instanceof MinecraftInstrument) || !(note.getVolume() > 0.0f)) continue;
                TxtNote txtNote = new TxtNote();
                txtNote.setInstrument(((MinecraftInstrument)note.getInstrument()).mcId());
                txtNote.setKey((byte)Math.max(0, Math.min(24, note.getMcKey())));
                newSong.getTxtNotes().computeIfAbsent(tick, k -> new ArrayList()).add(txtNote);
            }
        }
        return newSong;
    }
}

