/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.midi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import net.raphimc.noteblocklib.format.midi.mapping.InstrumentMapping;
import net.raphimc.noteblocklib.format.midi.mapping.MidiMappings;
import net.raphimc.noteblocklib.format.midi.mapping.PercussionMapping;
import net.raphimc.noteblocklib.format.midi.model.MidiSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.util.SongResampler;

public class MidiIo {
    public static MidiSong readSong(InputStream is, String fileName) throws IOException, InvalidMidiDataException {
        return MidiIo.parseSong(MidiSystem.getSequence(is), fileName);
    }

    public static MidiSong parseSong(Sequence sequence, String fileName) {
        MidiSong song = new MidiSong(fileName);
        if (sequence.getTickLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("MIDI sequence has too many ticks");
        }
        if (sequence.getDivisionType() == 0.0f) {
            song.getTempoEvents().set(0, (float)(1000000.0 / (500000.0 / (double)sequence.getResolution())));
        } else {
            song.getTempoEvents().set(0, (float)sequence.getResolution() * sequence.getDivisionType());
        }
        byte[] channelInstruments = new byte[16];
        byte[] channelVolumes = new byte[16];
        byte[] channelPans = new byte[16];
        Arrays.fill(channelVolumes, (byte)127);
        Arrays.fill(channelPans, (byte)64);
        for (int trackIdx = 0; trackIdx < sequence.getTracks().length; ++trackIdx) {
            Track track = sequence.getTracks()[trackIdx];
            for (int eventIdx = 0; eventIdx < track.size(); ++eventIdx) {
                MidiEvent event = track.get(eventIdx);
                MidiMessage message = event.getMessage();
                if (message instanceof ShortMessage) {
                    ShortMessage shortMessage = (ShortMessage)message;
                    block0 : switch (shortMessage.getCommand()) {
                        case 144: {
                            Object mapping;
                            byte instrument = channelInstruments[shortMessage.getChannel()];
                            byte key = (byte)shortMessage.getData1();
                            byte velocity = (byte)shortMessage.getData2();
                            byte pan = channelPans[shortMessage.getChannel()];
                            Note note = new Note();
                            if (shortMessage.getChannel() == 9) {
                                mapping = MidiMappings.PERCUSSION_MAPPINGS.get(key);
                                if (mapping == null) break;
                                note.setInstrument(((PercussionMapping)mapping).getInstrument());
                                note.setNbsKey(((PercussionMapping)mapping).getNbsKey());
                            } else {
                                mapping = MidiMappings.INSTRUMENT_MAPPINGS.get(instrument);
                                if (mapping == null) break;
                                note.setInstrument(((InstrumentMapping)mapping).getInstrument());
                                note.setMidiKey(Math.max(21, Math.min(108, key + 12 * ((InstrumentMapping)mapping).getOctaveModifier())));
                            }
                            note.setVolume((float)velocity / 127.0f * (float)channelVolumes[shortMessage.getChannel()] / 127.0f);
                            note.setPanning((float)(pan - 64) / 64.0f);
                            song.getNotes().add((int)event.getTick(), note);
                            break;
                        }
                        case 128: {
                            break;
                        }
                        case 192: {
                            channelInstruments[shortMessage.getChannel()] = (byte)shortMessage.getData1();
                            break;
                        }
                        case 176: {
                            switch (shortMessage.getData1()) {
                                case 7: {
                                    channelVolumes[shortMessage.getChannel()] = (byte)shortMessage.getData2();
                                    break block0;
                                }
                                case 10: {
                                    channelPans[shortMessage.getChannel()] = (byte)shortMessage.getData2();
                                    break block0;
                                }
                                case 121: {
                                    channelVolumes[shortMessage.getChannel()] = 127;
                                    channelPans[shortMessage.getChannel()] = 64;
                                }
                            }
                            break;
                        }
                        case 224: {
                            break;
                        }
                        case 255: {
                            Arrays.fill(channelInstruments, (byte)0);
                            Arrays.fill(channelVolumes, (byte)127);
                            Arrays.fill(channelPans, (byte)64);
                        }
                    }
                    continue;
                }
                if (!(message instanceof MetaMessage)) continue;
                MetaMessage metaMessage = (MetaMessage)message;
                byte[] data = metaMessage.getData();
                if (metaMessage.getType() == 81 && data.length == 3 && sequence.getDivisionType() == 0.0f) {
                    int newMpq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                    double microsPerTick = (double)newMpq / (double)sequence.getResolution();
                    song.getTempoEvents().set((int)event.getTick(), (float)(1000000.0 / microsPerTick));
                    continue;
                }
                if (metaMessage.getType() == 2) {
                    song.setOriginalAuthor(new String(data, StandardCharsets.US_ASCII));
                    continue;
                }
                if (metaMessage.getType() != 3) continue;
                song.getTrackNames().put(trackIdx, new String(data, StandardCharsets.US_ASCII));
            }
        }
        float maxTempo = song.getTempoEvents().getTempoRange()[1];
        if (maxTempo > 100.0f) {
            SongResampler.changeTickSpeed(song, 100.0f);
        }
        return song;
    }
}

