/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.futureclient;

import com.google.common.io.ByteStreams;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.futureclient.model.FutureClientNote;
import net.raphimc.noteblocklib.format.futureclient.model.FutureClientSong;
import net.raphimc.noteblocklib.model.Note;

public class FutureClientIo {
    private static final int BUFFER_SIZE = 0x100000;

    public static FutureClientSong readSong(InputStream is, String fileName) throws IOException {
        byte[] data;
        LittleEndianDataInputStream dis = new LittleEndianDataInputStream((InputStream)new BufferedInputStream(is, 0x100000));
        FutureClientSong song = new FutureClientSong(fileName);
        Map<Integer, List<FutureClientNote>> notes = song.getFutureClientNotes();
        boolean use64 = false;
        dis.mark(dis.available());
        for (byte b : data = ByteStreams.toByteArray((InputStream)dis)) {
            if (b != 64) continue;
            use64 = true;
            break;
        }
        dis.reset();
        int tick = 0;
        while (dis.available() > 0) {
            byte instrument = dis.readByte();
            if (instrument == (use64 ? (byte)64 : 5)) {
                tick += dis.readUnsignedShort();
                continue;
            }
            FutureClientNote note = new FutureClientNote();
            note.setInstrument(instrument);
            note.setKey(dis.readByte());
            notes.computeIfAbsent(tick, k -> new ArrayList()).add(note);
        }
        song.getTempoEvents().set(0, 20.0f);
        for (Map.Entry<Integer, List<FutureClientNote>> entry : notes.entrySet()) {
            for (FutureClientNote futureClientNote : entry.getValue()) {
                Note note = new Note();
                note.setInstrument(MinecraftInstrument.fromMcId(futureClientNote.getInstrument()));
                note.setMcKey(futureClientNote.getKey());
                song.getNotes().add((int)entry.getKey(), note);
            }
        }
        return song;
    }
}

