/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum SongFormat {
    NBS("nbs"),
    MCSP("mcsp"),
    MCSP2("mcsp2"),
    TXT("txt"),
    FUTURE_CLIENT("notebot"),
    MIDI("mid", "midi");

    private final List<String> extensions;

    private SongFormat(String ... extension) {
        this.extensions = Arrays.asList(extension);
    }

    public static SongFormat getByExtension(String extension) {
        for (SongFormat format : SongFormat.values()) {
            if (!format.extensions.contains(extension.toLowerCase(Locale.ROOT))) continue;
            return format;
        }
        return null;
    }

    public static SongFormat getByName(String name) {
        for (SongFormat format : SongFormat.values()) {
            if (!format.name().equalsIgnoreCase(name)) continue;
            return format;
        }
        return null;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public List<String> getExtensions() {
        return this.extensions;
    }
}

