/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.nbsplayer;

import io.github.kosmx.emotes.common.network.CommonNetwork;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.NbsDefinitions;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;

@Deprecated
public class LegacyNBSPacket {
    public static void write(NbsSong song, ByteBuffer buf) {
        buf.putInt(1);
        buf.put((byte)0);
        buf.put((byte)song.getVanillaInstrumentCount());
        buf.putShort(song.getTempo());
        buf.put(song.getTimeSignature());
        CommonNetwork.writeBoolean(buf, song.isLoop());
        buf.put(song.getMaxLoopCount());
        buf.putShort(song.getLoopStartTick());
        buf.putShort((short)song.getLayers().size());
        LegacyNBSPacket.writeLayersAndNotes(song, buf);
    }

    private static void writeLayersAndNotes(NbsSong song, ByteBuffer buf) {
        for (Map.Entry<Integer, NbsLayer> layerEntry : song.getLayers().entrySet()) {
            NbsLayer layer = layerEntry.getValue();
            buf.put(layer.getVolume());
            buf.put((byte)layer.getPanning());
            int tick = -1;
            for (Map.Entry<Integer, NbsNote> noteEntry : layer.getNotes().entrySet()) {
                NbsNote note = noteEntry.getValue();
                buf.putShort((short)(noteEntry.getKey() - tick));
                tick = noteEntry.getKey();
                buf.put((byte)note.getInstrument());
                buf.put(note.getKey());
                buf.put(note.getVelocity());
                buf.put((byte)note.getPanning());
                buf.putShort(note.getPitch());
            }
            buf.putShort((short)0);
        }
    }

    public static NbsSong read(ByteBuffer buf) throws IOException {
        buf.getInt();
        buf.get();
        NbsSong builder = new NbsSong();
        builder.setVersion((byte)5);
        builder.setVanillaInstrumentCount(buf.get());
        builder.setTempo(buf.getShort());
        builder.setTimeSignature(buf.get());
        builder.setLoop(CommonNetwork.readBoolean(buf));
        builder.setMaxLoopCount(buf.get());
        builder.setLoopStartTick(buf.getShort());
        builder.setLayerCount(buf.getShort());
        LegacyNBSPacket.readLayersAndNotes(builder, buf);
        return builder;
    }

    private static void readLayersAndNotes(NbsSong song, ByteBuffer buf) {
        Object note;
        Map<Integer, NbsLayer> layers = song.getLayers();
        if (song.getLayerCount() != layers.size()) {
            if (!layers.isEmpty()) {
                return;
            }
            for (int i = 0; i < song.getLayerCount(); ++i) {
                layers.put(i, new NbsLayer());
            }
        }
        int length = 0;
        for (Map.Entry<Integer, NbsLayer> layerEntry : layers.entrySet()) {
            NbsLayer layer = layerEntry.getValue();
            layer.setVolume(buf.get());
            layer.setPanning(buf.get());
            int tick = -1;
            short step = buf.getShort();
            while (step != 0) {
                tick += step;
                note = new NbsNote();
                ((NbsNote)note).setInstrument(buf.get());
                ((NbsNote)note).setKey(buf.get());
                ((NbsNote)note).setVelocity(buf.get());
                ((NbsNote)note).setPanning(buf.get());
                ((NbsNote)note).setPitch(buf.getShort());
                layer.getNotes().put(tick, (NbsNote)note);
                length = Math.max(length, tick);
                step = buf.getShort();
            }
        }
        song.setLength((short)length);
        song.getTempoEvents().set(0, (float)song.getTempo() / 100.0f);
        for (NbsLayer layer : layers.values()) {
            for (Map.Entry<Integer, NbsNote> noteEntry : layer.getNotes().entrySet()) {
                NbsNote nbsNote = noteEntry.getValue();
                note = new Note();
                ((Note)note).setNbsKey((float)NbsDefinitions.getEffectivePitch(nbsNote) / 100.0f);
                ((Note)note).setVolume((float)layer.getVolume() / 100.0f * ((float)nbsNote.getVelocity() / 100.0f));
                if (layer.getPanning() == 100) {
                    ((Note)note).setPanning((float)(nbsNote.getPanning() - 100) / 100.0f);
                } else {
                    ((Note)note).setPanning((float)(layer.getPanning() - 100 + (nbsNote.getPanning() - 100)) / 200.0f);
                }
                if (nbsNote.getInstrument() < song.getVanillaInstrumentCount()) {
                    ((Note)note).setInstrument(MinecraftInstrument.fromNbsId((byte)nbsNote.getInstrument()));
                }
                song.getNotes().add((int)noteEntry.getKey(), (Note)note);
            }
        }
    }

    public static int calculateMessageSize(NbsSong song) {
        int size = 15;
        for (NbsLayer layer : song.getLayers().values()) {
            size += LegacyNBSPacket.getLayerMessageSize(layer);
        }
        return size;
    }

    public static int getLayerMessageSize(NbsLayer layer) {
        return 4 + layer.getNotes().size() * 8;
    }
}

