/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;

public class SongResampler {
    public static void changeTickSpeed(Song song, float newTempo) {
        SongResampler.precomputeTempoEvents(song);
        float divider = song.getTempoEvents().get(0) / newTempo;
        if (divider == 1.0f) {
            return;
        }
        HashMap<Integer, List> newNotes = new HashMap<Integer, List>();
        Iterator<Object> iterator = song.getNotes().getTicks().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            newNotes.computeIfAbsent(Math.round((float)n / divider), k -> new ArrayList()).addAll(song.getNotes().get(n));
        }
        song.getNotes().clear();
        for (Map.Entry entry : newNotes.entrySet()) {
            song.getNotes().set((Integer)entry.getKey(), (List)entry.getValue());
        }
        song.getTempoEvents().set(0, newTempo);
    }

    public static void precomputeTempoEvents(Song song) {
        if (song.getTempoEvents().getTicks().size() <= 1) {
            return;
        }
        float newTempo = song.getTempoEvents().getTempoRange()[1];
        HashMap<Integer, List> newNotes = new HashMap<Integer, List>();
        TreeSet<Integer> ticks = new TreeSet<Integer>(song.getNotes().getTicks());
        ticks.addAll(song.getTempoEvents().getTicks());
        int lastTick = 0;
        float totalMilliseconds = 0.0f;
        Iterator<Object> iterator = ticks.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            float tps = song.getTempoEvents().getEffectiveTempo(lastTick);
            int ticksInSegment = n - lastTick;
            float segmentMilliseconds = (float)ticksInSegment / tps * 1000.0f;
            totalMilliseconds += segmentMilliseconds;
            lastTick = n;
            List<Note> notes = song.getNotes().get(n);
            if (notes == null) continue;
            int newTick = Math.round(newTempo * totalMilliseconds / 1000.0f);
            newNotes.computeIfAbsent(newTick, k -> new ArrayList()).addAll(notes);
        }
        song.getNotes().clear();
        for (Map.Entry entry : newNotes.entrySet()) {
            song.getNotes().set((Integer)entry.getKey(), (List)entry.getValue());
        }
        song.getTempoEvents().clear();
        song.getTempoEvents().set(0, newTempo);
    }
}

