/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.model.Song;

public class NbsSong
extends Song {
    private short length;
    private byte version;
    private int vanillaInstrumentCount;
    private short layerCount;
    private short tempo;
    private boolean autoSave;
    private byte autoSaveInterval;
    private byte timeSignature;
    private int minutesSpent;
    private int leftClicks;
    private int rightClicks;
    private int noteBlocksAdded;
    private int noteBlocksRemoved;
    private String sourceFileName;
    private boolean loop;
    private byte maxLoopCount;
    private short loopStartTick;
    private final Map<Integer, NbsLayer> layers = new HashMap<Integer, NbsLayer>();
    private final List<NbsCustomInstrument> customInstruments = new ArrayList<NbsCustomInstrument>();

    public NbsSong() {
        this(null);
    }

    public NbsSong(String fileName) {
        super(SongFormat.NBS, fileName);
        this.version = (byte)5;
        this.vanillaInstrumentCount = MinecraftInstrument.values().length;
    }

    public short getLength() {
        return this.length;
    }

    public NbsSong setLength(short length) {
        this.length = length;
        return this;
    }

    public byte getVersion() {
        return this.version;
    }

    public NbsSong setVersion(byte version) {
        this.version = version;
        return this;
    }

    public int getVanillaInstrumentCount() {
        return this.vanillaInstrumentCount;
    }

    public NbsSong setVanillaInstrumentCount(int vanillaInstrumentCount) {
        this.vanillaInstrumentCount = vanillaInstrumentCount;
        return this;
    }

    public short getLayerCount() {
        return this.layerCount;
    }

    public NbsSong setLayerCount(short layerCount) {
        this.layerCount = layerCount;
        return this;
    }

    public short getTempo() {
        return this.tempo;
    }

    public NbsSong setTempo(short tempo) {
        this.tempo = tempo;
        return this;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public NbsSong setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
        return this;
    }

    public byte getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public NbsSong setAutoSaveInterval(byte autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
        return this;
    }

    public byte getTimeSignature() {
        return this.timeSignature;
    }

    public NbsSong setTimeSignature(byte timeSignature) {
        this.timeSignature = timeSignature;
        return this;
    }

    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    public NbsSong setMinutesSpent(int minutesSpent) {
        this.minutesSpent = minutesSpent;
        return this;
    }

    public int getLeftClicks() {
        return this.leftClicks;
    }

    public NbsSong setLeftClicks(int leftClicks) {
        this.leftClicks = leftClicks;
        return this;
    }

    public int getRightClicks() {
        return this.rightClicks;
    }

    public NbsSong setRightClicks(int rightClicks) {
        this.rightClicks = rightClicks;
        return this;
    }

    public int getNoteBlocksAdded() {
        return this.noteBlocksAdded;
    }

    public NbsSong setNoteBlocksAdded(int noteBlocksAdded) {
        this.noteBlocksAdded = noteBlocksAdded;
        return this;
    }

    public int getNoteBlocksRemoved() {
        return this.noteBlocksRemoved;
    }

    public NbsSong setNoteBlocksRemoved(int noteBlocksRemoved) {
        this.noteBlocksRemoved = noteBlocksRemoved;
        return this;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSourceFileNameOr(String fallback) {
        return this.sourceFileName == null ? fallback : this.sourceFileName;
    }

    public NbsSong setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName != null && !sourceFileName.isEmpty() ? sourceFileName : null;
        return this;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public NbsSong setLoop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public byte getMaxLoopCount() {
        return this.maxLoopCount;
    }

    public NbsSong setMaxLoopCount(byte maxLoopCount) {
        this.maxLoopCount = maxLoopCount;
        return this;
    }

    public short getLoopStartTick() {
        return this.loopStartTick;
    }

    public NbsSong setLoopStartTick(short loopStartTick) {
        this.loopStartTick = loopStartTick;
        return this;
    }

    public Map<Integer, NbsLayer> getLayers() {
        return this.layers;
    }

    public List<NbsCustomInstrument> getCustomInstruments() {
        return this.customInstruments;
    }

    @Override
    public NbsSong copy() {
        NbsSong copySong = new NbsSong(this.getFileName());
        copySong.copyGeneralData(this);
        copySong.setVersion(this.getVersion());
        copySong.setVanillaInstrumentCount(this.getVanillaInstrumentCount());
        copySong.setLayerCount(this.getLayerCount());
        copySong.setTempo(this.getTempo());
        copySong.setAutoSave(this.isAutoSave());
        copySong.setAutoSaveInterval(this.getAutoSaveInterval());
        copySong.setTimeSignature(this.getTimeSignature());
        copySong.setMinutesSpent(this.getMinutesSpent());
        copySong.setLeftClicks(this.getLeftClicks());
        copySong.setRightClicks(this.getRightClicks());
        copySong.setNoteBlocksAdded(this.getNoteBlocksAdded());
        copySong.setNoteBlocksRemoved(this.getNoteBlocksRemoved());
        copySong.setSourceFileName(this.getSourceFileName());
        copySong.setLoop(this.isLoop());
        copySong.setMaxLoopCount(this.getMaxLoopCount());
        copySong.setLoopStartTick(this.getLoopStartTick());
        Map<Integer, NbsLayer> layers = this.getLayers();
        Map<Integer, NbsLayer> copyLayers = copySong.getLayers();
        for (Map.Entry<Integer, NbsLayer> entry : layers.entrySet()) {
            copyLayers.put(entry.getKey(), entry.getValue().copy());
        }
        List<NbsCustomInstrument> customInstruments = this.getCustomInstruments();
        List<NbsCustomInstrument> copyCustomInstruments = copySong.getCustomInstruments();
        for (NbsCustomInstrument customInstrument : customInstruments) {
            copyCustomInstruments.add(customInstrument.copy());
        }
        return copySong;
    }
}

