/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.data;

import java.util.EnumMap;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.instrument.Instrument;

public class MinecraftDefinitions {
    public static final int MC_LOWEST_MIDI_KEY = 54;
    public static final int MC_HIGHEST_MIDI_KEY = 78;
    public static final int MC_LOWEST_KEY = 0;
    public static final int MC_HIGHEST_KEY = 24;
    public static final int MC_KEYS = 24;
    private static final Map<MinecraftInstrument, MinecraftInstrument[][]> INSTRUMENT_SHIFTS = new EnumMap<MinecraftInstrument, MinecraftInstrument[][]>(MinecraftInstrument.class);

    public static void clampNoteKey(Note note) {
        note.setMidiKey(Math.max(54.0f, Math.min(78.0f, note.getMidiKey())));
    }

    public static void transposeNoteKey(Note note) {
        MinecraftDefinitions.transposeNoteKey(note, 12);
    }

    public static void transposeNoteKey(Note note, int transposeAmount) {
        float key;
        for (key = note.getMidiKey(); key < 54.0f; key += (float)transposeAmount) {
        }
        while (key > 78.0f) {
            key -= (float)transposeAmount;
        }
        note.setMidiKey(key);
    }

    public static void instrumentShiftNote(Note note) {
        float key;
        Instrument instrument = note.getInstrument();
        if (!(instrument instanceof MinecraftInstrument)) {
            return;
        }
        MinecraftInstrument[][] shifts = INSTRUMENT_SHIFTS.get(instrument);
        if (shifts == null) {
            return;
        }
        int downShifts = 0;
        for (key = note.getMidiKey(); key < 54.0f && downShifts < shifts[0].length; key += 24.0f) {
            instrument = shifts[0][downShifts++];
        }
        int upShifts = 0;
        while (key > 78.0f && upShifts < shifts[1].length) {
            instrument = shifts[1][upShifts++];
            key -= 24.0f;
        }
        note.setInstrument(instrument);
        note.setMidiKey(key);
    }

    public static int applyExtendedNotesResourcePack(Note note) {
        int octavesDelta = 0;
        while (note.getMidiKey() < 54.0f) {
            note.setMidiKey(note.getMidiKey() + 24.0f);
            --octavesDelta;
        }
        while (note.getMidiKey() > 78.0f) {
            note.setMidiKey(note.getMidiKey() - 24.0f);
            ++octavesDelta;
        }
        return octavesDelta;
    }

    static {
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.HARP, new MinecraftInstrument[][]{{MinecraftInstrument.BASS}, {MinecraftInstrument.BELL}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.BASS, new MinecraftInstrument[][]{new MinecraftInstrument[0], {MinecraftInstrument.HARP, MinecraftInstrument.BELL}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.BASS_DRUM, new MinecraftInstrument[][]{new MinecraftInstrument[0], {MinecraftInstrument.SNARE}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.SNARE, new MinecraftInstrument[][]{{MinecraftInstrument.BASS_DRUM}, {MinecraftInstrument.HAT}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.HAT, new MinecraftInstrument[][]{{MinecraftInstrument.BASS_DRUM}, {MinecraftInstrument.CHIME}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.GUITAR, new MinecraftInstrument[][]{{MinecraftInstrument.BASS}, {MinecraftInstrument.COW_BELL, MinecraftInstrument.XYLOPHONE}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.FLUTE, new MinecraftInstrument[][]{{MinecraftInstrument.DIDGERIDOO}, {MinecraftInstrument.BELL, MinecraftInstrument.CHIME}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.BELL, new MinecraftInstrument[][]{{MinecraftInstrument.HARP}, new MinecraftInstrument[0]});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.CHIME, new MinecraftInstrument[][]{{MinecraftInstrument.BELL}, new MinecraftInstrument[0]});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.XYLOPHONE, new MinecraftInstrument[][]{{MinecraftInstrument.COW_BELL}, {MinecraftInstrument.CHIME}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.IRON_XYLOPHONE, new MinecraftInstrument[][]{{MinecraftInstrument.BASS}, {MinecraftInstrument.BELL}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.COW_BELL, new MinecraftInstrument[][]{{MinecraftInstrument.GUITAR}, {MinecraftInstrument.XYLOPHONE}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.DIDGERIDOO, new MinecraftInstrument[][]{{MinecraftInstrument.BASS}, {MinecraftInstrument.FLUTE, MinecraftInstrument.BELL}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.BIT, new MinecraftInstrument[][]{{MinecraftInstrument.DIDGERIDOO}, {MinecraftInstrument.BELL}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.BANJO, new MinecraftInstrument[][]{{MinecraftInstrument.DIDGERIDOO}, {MinecraftInstrument.BELL}});
        INSTRUMENT_SHIFTS.put(MinecraftInstrument.PLING, new MinecraftInstrument[][]{{MinecraftInstrument.BASS}, {MinecraftInstrument.BELL}});
    }
}

