/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer.type;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.quarktool.QuarkReader;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import io.github.kosmx.emotes.server.serializer.type.IReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class QuarkReaderWrapper
implements IReader {
    @Override
    public List<KeyframeAnimation> read(InputStream stream, String filename) throws EmoteSerializerException {
        List<KeyframeAnimation> list;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            QuarkReader quarkReader = new QuarkReader();
            quarkReader.deserialize(reader, filename);
            list = Collections.singletonList(quarkReader.getEmote());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable th) {
                throw new EmoteSerializerException("Quark error", this.getExtension(), th);
            }
        }
        reader.close();
        return list;
    }

    @Override
    public String getExtension() {
        return "emote";
    }

    @Override
    public boolean isActive() {
        return Serializer.getConfig().enableQuark.get();
    }
}

