/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer.type;

import com.google.gson.JsonParseException;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;

public class JsonEmoteWrapper
implements ISerializer {
    @Override
    public List<KeyframeAnimation> read(InputStream inputStream, String filename) throws EmoteSerializerException {
        try {
            List<KeyframeAnimation> deserialized = AnimationSerializing.deserializeAnimation(inputStream);
            if (deserialized == null) {
                throw new IOException("Can't load emote, " + filename + " is empty.");
            }
            return this.fixStopTick(deserialized);
        }
        catch (JsonParseException | IOException e) {
            throw new EmoteSerializerException("Exception has occurred", this.getExtension(), e);
        }
    }

    @Override
    public void write(KeyframeAnimation emote, OutputStream outputStream, String filename) throws EmoteSerializerException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            AnimationSerializing.writeAnimation(emote, bufferedWriter);
        }
        catch (Exception e) {
            throw new EmoteSerializerException("Exception has occurred", this.getExtension(), e);
        }
    }

    @Override
    public boolean onlyEmoteFile() {
        return true;
    }

    @Override
    public String getExtension() {
        return "json";
    }

    private List<KeyframeAnimation> fixStopTick(List<KeyframeAnimation> deserializeAnimation) {
        if (!Serializer.getConfig().autoFixEmoteStop.get().booleanValue()) {
            return deserializeAnimation;
        }
        LinkedList<KeyframeAnimation> fixed = new LinkedList<KeyframeAnimation>();
        for (KeyframeAnimation emote : deserializeAnimation) {
            if (emote.endTick + 1 == emote.stopTick && !emote.isInfinite()) {
                KeyframeAnimation.AnimationBuilder builder = emote.mutableCopy();
                int last = 0;
                last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.body));
                last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.head));
                last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.leftArm));
                last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.rightArm));
                last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.leftLeg));
                last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.rightLeg));
                builder.endTick = last = Math.max(last, JsonEmoteWrapper.lastKeyPos(builder.torso));
                fixed.add(builder.build());
                continue;
            }
            fixed.add(emote);
        }
        return fixed;
    }

    private static int lastKeyPos(KeyframeAnimation.StateCollection part) {
        int last = 0;
        last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.x));
        last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.y));
        last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.z));
        last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.pitch));
        last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.yaw));
        last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.roll));
        if (part.bend != null) {
            last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.bend));
        }
        if (part.bendDirection != null) {
            last = Math.max(last, JsonEmoteWrapper.lastKeyPos(part.bendDirection));
        }
        return last;
    }

    private static int lastKeyPos(KeyframeAnimation.StateCollection.State part) {
        if (part.getKeyFrames().isEmpty()) {
            return 0;
        }
        return part.getKeyFrames().getLast().tick;
    }
}

