/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.api.services.LoggerService;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.tools.ServiceLoaderUtil;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.serializer.EmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import io.github.kosmx.emotes.server.serializer.type.IReader;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class UniversalEmoteSerializer {
    public static final List<IReader> READERS = ServiceLoaderUtil.loadServicesSorted(IReader.class).toList();
    public static final UUIDMap<KeyframeAnimation> SERVER_EMOTES = new UUIDMap();
    public static final UUIDMap<KeyframeAnimation> HIDDEN_SERVER_EMOTES = new UUIDMap();

    public static List<KeyframeAnimation> readData(InputStream inputStream, @Nullable String filename, String format) throws EmoteSerializerException {
        return UniversalEmoteSerializer.readData(inputStream, (String)((Object)Objects.requireNonNullElse(filename, "emote." + format)));
    }

    public static List<KeyframeAnimation> readData(InputStream inputStream, String fileName) throws EmoteSerializerException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("filename can not be null if no format type was given");
        }
        try {
            return UniversalEmoteSerializer.findReader(fileName).orElseThrow(() -> new EmoteSerializerException("No known reader for format", fileName)).read(inputStream, fileName);
        }
        catch (EmoteSerializerException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new EmoteSerializerException("Error has occurred while serializing an emote", fileName, cause);
        }
    }

    public static Optional<IReader> findReader(String fileName) {
        return READERS.stream().filter(reader -> reader.canRead(fileName)).findFirst();
    }

    public static void writeKeyframeAnimation(OutputStream stream, KeyframeAnimation emote, String fileName) throws EmoteSerializerException {
        UniversalEmoteSerializer.getSerializers().filter(serializer -> serializer.canRead(fileName)).findFirst().orElseThrow(() -> new EmoteSerializerException("No writer has been found for format!", fileName)).write(emote, stream, fileName);
    }

    public static Stream<ISerializer> getSerializers() {
        return READERS.stream().filter(reader -> reader instanceof ISerializer).map(reader -> (ISerializer)reader);
    }

    public static void loadEmotes() {
        SERVER_EMOTES.clear();
        HIDDEN_SERVER_EMOTES.clear();
        UniversalEmoteSerializer.serializeInternalJson("waving");
        UniversalEmoteSerializer.serializeInternalJson("clap");
        UniversalEmoteSerializer.serializeInternalJson("crying");
        UniversalEmoteSerializer.serializeInternalJson("point");
        UniversalEmoteSerializer.serializeInternalJson("here");
        UniversalEmoteSerializer.serializeInternalJson("palm");
        UniversalEmoteSerializer.serializeInternalJson("backflip");
        UniversalEmoteSerializer.serializeInternalJson("roblox_potion_dance");
        UniversalEmoteSerializer.serializeInternalJson("kazotsky_kick");
        UniversalEmoteSerializer.serializeInternalJson("twerk");
        UniversalEmoteSerializer.serializeInternalJson("club_penguin_dance");
        Path path = InstanceService.INSTANCE.getExternalEmoteDir();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        EmoteSerializer.serializeEmotes(Serializer.getConfig().loadEmotesServerSide.get() != false ? SERVER_EMOTES : HIDDEN_SERVER_EMOTES, path);
        Path serverEmotesDir = path.resolve("server");
        if (Files.isDirectory(serverEmotesDir, new LinkOption[0])) {
            EmoteSerializer.serializeEmotes(SERVER_EMOTES, serverEmotesDir);
        }
    }

    private static void serializeInternalJson(String name) {
        if (!Serializer.getConfig().loadBuiltinEmotes.get().booleanValue()) {
            return;
        }
        try (InputStream stream = UniversalEmoteSerializer.class.getResourceAsStream("/assets/emotecraft/emotes/" + name + ".json");){
            List<KeyframeAnimation> emotes = UniversalEmoteSerializer.readData(stream, name + ".json");
            for (KeyframeAnimation emote : emotes) {
                emote.extraData.put("isBuiltin", true);
                InputStream iconStream = UniversalEmoteSerializer.class.getResourceAsStream("/assets/emotecraft/emotes/" + name + ".png");
                if (iconStream == null) continue;
                emote.extraData.put("iconData", MathHelper.readFromIStream(iconStream));
                iconStream.close();
            }
            HIDDEN_SERVER_EMOTES.addAll(emotes);
        }
        catch (EmoteSerializerException | IOException e) {
            LoggerService.INSTANCE.log(Level.WARNING, "Failed to load built-in emote!", e);
        }
    }

    @Nullable
    public static KeyframeAnimation getEmote(UUID uuid) {
        return SERVER_EMOTES.getOrDefault(uuid, (KeyframeAnimation)HIDDEN_SERVER_EMOTES.get(uuid));
    }

    public static UUIDMap<KeyframeAnimation> getLoadedEmotes() {
        UUIDMap<KeyframeAnimation> map = new UUIDMap<KeyframeAnimation>();
        map.putAll(HIDDEN_SERVER_EMOTES);
        map.putAll(SERVER_EMOTES);
        return map;
    }

    public static Stream<ByteBuffer> preparePackets(HashMap<Byte, Byte> compatibilityMap) {
        return SERVER_EMOTES.values().stream().map(emote -> {
            try {
                return new EmotePacket.Builder().configureToSaveEmote((KeyframeAnimation)emote).setSizeLimit(0x100000, false).setVersion(compatibilityMap).build().write();
            }
            catch (IOException e) {
                LoggerService.INSTANCE.log(Level.WARNING, "Failed to prepare emote packet!", e);
                return null;
            }
        }).filter(Objects::nonNull);
    }
}

