/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.api.services.LoggerService;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.model.Song;

public class EmoteSerializer {
    public static final String FOLDER_PATH_KEY = "folderpath";

    public static void serializeEmotes(UUIDMap<KeyframeAnimation> emotes, Path externalEmotes) {
        if (!Files.isDirectory(externalEmotes, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(externalEmotes, FileVisitOption.FOLLOW_LINKS);){
            ((Stream)paths.filter(file -> UniversalEmoteSerializer.findReader(file.getFileName().toString()).isPresent()).parallel()).forEach(file -> {
                String folderPath = externalEmotes.relativize(file.getParent()).normalize().toString().replace(File.separator, "/");
                if (folderPath.startsWith("server") || folderPath.contains("_export")) {
                    return;
                }
                emotes.addAll(EmoteSerializer.serializeExternalEmote(file, folderPath));
            });
        }
        catch (Throwable e) {
            LoggerService.INSTANCE.log(Level.WARNING, "Failed to walk emotes!", e);
        }
    }

    public static List<KeyframeAnimation> serializeExternalEmote(Path file) {
        return EmoteSerializer.serializeExternalEmote(file, null);
    }

    public static List<KeyframeAnimation> serializeExternalEmote(Path file, String folderPath) {
        List<KeyframeAnimation> list;
        block25: {
            String fileName = file.getFileName().toString();
            String baseFileName = EmoteSerializer.getBaseName(fileName);
            InputStream reader = Files.newInputStream(file, new OpenOption[0]);
            try {
                Path song;
                Path icon;
                List<KeyframeAnimation> emotes = UniversalEmoteSerializer.readData(reader, fileName);
                if (folderPath != null && !folderPath.isBlank()) {
                    for (KeyframeAnimation emote : emotes) {
                        emote.extraData.put(FOLDER_PATH_KEY, folderPath);
                    }
                }
                if (Files.isRegularFile(icon = file.getParent().resolve(baseFileName + ".png"), new LinkOption[0])) {
                    try (InputStream iconStream = Files.newInputStream(icon, new OpenOption[0]);){
                        ByteBuffer byteBuffer = MathHelper.readFromIStream(iconStream);
                        for (KeyframeAnimation emote : emotes) {
                            emote.extraData.put("iconData", byteBuffer);
                        }
                    }
                    catch (Throwable th) {
                        LoggerService.INSTANCE.log(Level.WARNING, "Error while reading icon: " + String.valueOf(icon.getFileName()), th);
                    }
                }
                if (Files.isRegularFile(song = file.getParent().resolve(baseFileName + ".nbs"), new LinkOption[0])) {
                    try {
                        Song nbs = NoteBlockLib.readSong(song, SongFormat.NBS);
                        for (KeyframeAnimation emote : emotes) {
                            emote.extraData.put("song", nbs);
                        }
                    }
                    catch (Throwable th) {
                        LoggerService.INSTANCE.log(Level.WARNING, "Error while reading song: " + String.valueOf(song.getFileName()), th);
                    }
                }
                list = emotes;
                if (reader == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable th) {
                    LoggerService.INSTANCE.log(Level.WARNING, "Error while importing external emote: " + String.valueOf(file.getFileName()), th);
                    return Collections.emptyList();
                }
            }
            reader.close();
        }
        return list;
    }

    private static String getBaseName(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            fileName = fileName.substring(0, i);
        }
        return fileName;
    }
}

