/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.mc;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.mc.McUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;

public class EmoteArgumentProvider
implements SuggestionProvider<CommandSourceStack> {
    public final Function<CommandContext<CommandSourceStack>, Map<UUID, KeyframeAnimation>> emotes;
    public final HolderLookup.Provider registries;

    public EmoteArgumentProvider(Function<CommandContext<CommandSourceStack>, Map<UUID, KeyframeAnimation>> emotes) {
        this((HolderLookup.Provider)RegistryAccess.EMPTY, emotes);
    }

    public EmoteArgumentProvider(HolderLookup.Provider registries, Function<CommandContext<CommandSourceStack>, Map<UUID, KeyframeAnimation>> emotes) {
        this.emotes = emotes;
        this.registries = registries;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LinkedList<String> suggestions = new LinkedList<String>();
        for (KeyframeAnimation emote : this.emotes.apply(context).values()) {
            if (emote.extraData.containsKey("name")) {
                Object name = McUtils.fromJson(emote.extraData.get("name"), this.registries).getString();
                if (((String)name).contains(" ")) {
                    name = "\"" + (String)name + "\"";
                }
                suggestions.add(StringUtil.filterText((String)name));
                continue;
            }
            suggestions.add(emote.getUuid().toString());
        }
        return SharedSuggestionProvider.suggest((String[])((String[])suggestions.toArray(String[]::new)), (SuggestionsBuilder)builder);
    }

    public static KeyframeAnimation getEmote(Map<UUID, KeyframeAnimation> emotes, CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)argumentName);
        try {
            UUID emoteID = UUID.fromString(id);
            KeyframeAnimation emote = emotes.get(emoteID);
            if (emote == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)("No emote with ID: " + String.valueOf(emoteID)))).create();
            }
            return emote;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (KeyframeAnimation emote : emotes.values()) {
                String name;
                if (!emote.extraData.containsKey("name") || !(name = StringUtil.filterText((String)McUtils.fromJson(emote.extraData.get("name"), (HolderLookup.Provider)RegistryAccess.EMPTY).getString())).equals(id)) continue;
                return emote;
            }
            throw new SimpleCommandExceptionType((Message)Component.literal((String)("Not emote with name: " + id))).create();
        }
    }
}

