/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.nbsplayer.LegacyNBSPacket;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.tools.ByteBufferInputStream;
import io.github.kosmx.emotes.common.tools.ByteBufferOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Song;

public class SongPacket
extends AbstractNetworkPacket {
    @Override
    public byte getID() {
        return 3;
    }

    @Override
    public byte getVer() {
        return 2;
    }

    @Override
    public boolean read(ByteBuffer byteBuffer, NetData config, int version) throws IOException {
        Song song;
        switch (version) {
            case 2: {
                Song song2;
                try {
                    song = song2 = NoteBlockLib.readSong(new ByteBufferInputStream(byteBuffer), SongFormat.NBS);
                    break;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            case 1: {
                Song song2;
                LegacyNBSPacket reader = new LegacyNBSPacket();
                reader.read(byteBuffer);
                song = song2 = reader.getSong();
                break;
            }
            default: {
                Song song2;
                song = song2 = null;
            }
        }
        Song song3 = song;
        config.extraData.put("song", song3);
        return song3 != null;
    }

    @Override
    public void write(ByteBuffer byteBuffer, NetData config) throws IOException {
        if (!this.doWrite(config)) {
            throw new IOException("You can't write disabled or not existing NBS data");
        }
        assert (config.emoteData != null);
        Song song = (Song)config.emoteData.extraData.get("song");
        byte version = this.getVer(config.versions);
        if (version > 1) {
            try {
                NoteBlockLib.writeSong(song, new ByteBufferOutputStream(byteBuffer));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            LegacyNBSPacket writer = new LegacyNBSPacket((NbsSong)song);
            writer.write(byteBuffer);
        }
    }

    @Override
    public boolean doWrite(NetData config) {
        return config.versions.get(this.getID()) != 0 && config.emoteData != null && config.emoteData.extraData.containsKey("song") && config.writeSong;
    }

    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null || config.emoteData.extraData.get("song") == null) {
            return 0;
        }
        Song song = (Song)config.emoteData.extraData.get("song");
        if (this.getVer(config.versions) > 1) {
            return SongPacket.calculateSongSize(song);
        }
        return LegacyNBSPacket.calculateMessageSize((NbsSong)song);
    }

    public static int calculateSongSize(Song song) {
        int n;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NoteBlockLib.writeSong(song, os);
            n = os.size();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        os.close();
        return n;
    }
}

