/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.common.network.PacketTask;
import java.util.HashMap;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public final class NetData {
    public PacketTask purpose = PacketTask.UNKNOWN;
    public float threshold;
    @Nullable
    public UUID stopEmoteID = null;
    @Nullable
    public KeyframeAnimation emoteData = null;
    public int tick = 0;
    public boolean valid;
    public boolean writeSong = true;
    public boolean versionsUpdated = false;
    public HashMap<Byte, Byte> versions;
    @Nullable
    public UUID player = null;
    public boolean isForced = false;
    public int sizeLimit = 0x100000;
    public boolean strictSizeLimit = true;
    HashMap<String, Object> extraData = new HashMap();

    public boolean prepareAndValidate() {
        if (this.emoteData != null && !this.extraData.isEmpty()) {
            this.emoteData.extraData.putAll(this.extraData);
        }
        if (this.purpose == PacketTask.UNKNOWN) {
            return false;
        }
        if (this.purpose == PacketTask.STOP && this.stopEmoteID == null) {
            return false;
        }
        if (this.purpose == PacketTask.STREAM && this.emoteData == null) {
            return false;
        }
        if (this.purpose == PacketTask.CONFIG && !this.versionsUpdated) {
            return false;
        }
        return this.emoteData == null || this.stopEmoteID == null;
    }

    public NetData copy() {
        NetData data = new NetData();
        data.purpose = this.purpose;
        data.threshold = this.threshold;
        data.stopEmoteID = this.stopEmoteID;
        data.emoteData = this.emoteData;
        data.tick = this.tick;
        data.valid = this.valid;
        data.versionsUpdated = this.versionsUpdated;
        data.versions = this.versions;
        data.player = this.player;
        data.sizeLimit = this.sizeLimit;
        data.isForced = this.isForced;
        return data;
    }

    public String toString() {
        return "NetData{purpose=" + String.valueOf((Object)this.purpose) + ", threshold=" + this.threshold + ", stopEmoteID=" + String.valueOf(this.stopEmoteID) + ", emoteData=" + String.valueOf(this.emoteData) + ", startingAt=" + this.tick + ", player=" + String.valueOf(this.player) + "}";
    }
}

