/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import dev.kosmx.playerAnim.core.data.AnimationBinary;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EmoteDataPacket
extends AbstractNetworkPacket {
    @Override
    public void write(ByteBuffer buf, NetData config) {
        byte version = this.getVer(config.versions);
        assert (config.emoteData != null);
        buf.putInt(config.tick);
        AnimationBinary.write(config.emoteData, buf, version);
    }

    @Override
    public boolean read(ByteBuffer buf, NetData config, int version) throws IOException {
        try {
            config.tick = buf.getInt();
            config.emoteData = AnimationBinary.read(buf, version);
            config.valid = (Boolean)config.emoteData.extraData.get("valid");
            return true;
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public byte getID() {
        return 0;
    }

    @Override
    public byte getVer() {
        return (byte)AnimationBinary.getCurrentVersion();
    }

    @Override
    public boolean doWrite(NetData data) {
        return data.emoteData != null && data.stopEmoteID == null;
    }

    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null) {
            return 0;
        }
        return AnimationBinary.calculateSize(config.emoteData, this.getVer(config.versions)) + 4;
    }
}

