/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.nbsplayer;

import dev.kosmx.playerAnim.core.util.NetworkHelper;
import io.github.kosmx.emotes.common.network.CommonNetwork;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.NbsDefinitions;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;

public class LegacyNBSPacket {
    NbsSong song;
    boolean sendExtraData = false;
    int version = 1;
    final int packetVersion = 1;
    boolean valid = true;

    public LegacyNBSPacket(NbsSong song) {
        this.song = song;
    }

    public LegacyNBSPacket() {
    }

    public NbsSong getSong() {
        return this.song;
    }

    public void write(ByteBuffer buf) {
        buf.putInt(1);
        buf.put((byte)(this.sendExtraData ? 1 : 0));
        buf.put((byte)this.song.getVanillaInstrumentCount());
        if (this.sendExtraData) {
            buf.putShort(this.song.getLength());
            NetworkHelper.writeString(buf, this.song.getTitleOrFileNameOr(""));
            NetworkHelper.writeString(buf, this.song.getAuthorOr(""));
            NetworkHelper.writeString(buf, this.song.getOriginalAuthorOr(""));
            NetworkHelper.writeString(buf, this.song.getDescriptionOr(""));
        }
        buf.putShort(this.song.getTempo());
        if (this.sendExtraData) {
            CommonNetwork.writeBoolean(buf, this.song.isAutoSave());
            buf.put(this.song.getAutoSaveInterval());
        }
        buf.put(this.song.getTimeSignature());
        if (this.sendExtraData) {
            buf.putInt(this.song.getMinutesSpent());
            buf.putInt(this.song.getLeftClicks());
            buf.putInt(this.song.getRightClicks());
            buf.putInt(this.song.getNoteBlocksAdded());
            buf.putInt(this.song.getNoteBlocksRemoved());
            NetworkHelper.writeString(buf, this.song.getSourceFileNameOr(""));
        }
        CommonNetwork.writeBoolean(buf, this.song.isLoop());
        buf.put(this.song.getMaxLoopCount());
        buf.putShort(this.song.getLoopStartTick());
        buf.putShort((short)this.song.getLayers().size());
        this.writeLayersAndNotes(buf);
    }

    public void writeLayersAndNotes(ByteBuffer buf) {
        for (Map.Entry<Integer, NbsLayer> layerEntry : this.song.getLayers().entrySet()) {
            NbsLayer layer = layerEntry.getValue();
            if (this.sendExtraData) {
                NetworkHelper.writeString(buf, layer.getNameOr(""));
                CommonNetwork.writeBoolean(buf, layer.isLocked());
            }
            buf.put(layer.getVolume());
            buf.put((byte)layer.getPanning());
            int tick = -1;
            for (Map.Entry<Integer, NbsNote> noteEntry : layer.getNotes().entrySet()) {
                NbsNote note = noteEntry.getValue();
                buf.putShort((short)(noteEntry.getKey() - tick));
                tick = noteEntry.getKey();
                buf.put((byte)note.getInstrument());
                buf.put(note.getKey());
                buf.put(note.getVelocity());
                buf.put((byte)note.getPanning());
                buf.putShort(note.getPitch());
            }
            buf.putShort((short)0);
        }
    }

    public boolean read(ByteBuffer buf) throws IOException {
        this.version = buf.getInt();
        this.sendExtraData = buf.get() != 0;
        NbsSong builder = new NbsSong();
        builder.setVersion((byte)5);
        builder.setVanillaInstrumentCount(buf.get());
        if (this.sendExtraData) {
            builder.setLength(buf.getShort());
            builder.setTitle(NetworkHelper.readString(buf));
            builder.setAuthor(NetworkHelper.readString(buf));
            builder.setOriginalAuthor(NetworkHelper.readString(buf));
            builder.setDescription(NetworkHelper.readString(buf));
        }
        builder.setTempo(buf.getShort());
        if (this.sendExtraData) {
            builder.setAutoSave(CommonNetwork.readBoolean(buf));
            builder.setAutoSaveInterval(buf.get());
        }
        builder.setTimeSignature(buf.get());
        if (this.sendExtraData) {
            builder.setMinutesSpent(buf.getInt());
            builder.setLeftClicks(buf.getInt());
            builder.setRightClicks(buf.getInt());
            builder.setNoteBlocksAdded(buf.getInt());
            builder.setNoteBlocksRemoved(buf.getInt());
            builder.setSourceFileName(NetworkHelper.readString(buf));
        }
        builder.setLoop(CommonNetwork.readBoolean(buf));
        builder.setMaxLoopCount(buf.get());
        builder.setLoopStartTick(buf.getShort());
        builder.setLayerCount(buf.getShort());
        this.song = builder;
        this.readLayersAndNotes(buf);
        return this.valid;
    }

    void readLayersAndNotes(ByteBuffer buf) throws IOException {
        Map<Integer, NbsLayer> layers = this.song.getLayers();
        if (this.song.getLayerCount() != layers.size()) {
            if (!layers.isEmpty()) {
                this.valid = false;
                return;
            }
            for (int i = 0; i < this.song.getLayerCount(); ++i) {
                layers.put(i, new NbsLayer());
            }
        }
        int length = 0;
        for (Map.Entry<Integer, NbsLayer> layerEntry : layers.entrySet()) {
            NbsLayer layer = layerEntry.getValue();
            boolean locked = false;
            if (this.sendExtraData) {
                layer.setName(NetworkHelper.readString(buf));
                locked = buf.get() != 0;
            }
            layer.setVolume(buf.get());
            layer.setPanning(buf.get());
            int tick = -1;
            short step = buf.getShort();
            while (step != 0) {
                tick += step;
                NbsNote note = new NbsNote();
                note.setInstrument(buf.get());
                note.setKey(buf.get());
                note.setVelocity(buf.get());
                note.setPanning(buf.get());
                note.setPitch(buf.getShort());
                layer.getNotes().put(tick, note);
                length = Math.max(length, tick);
                step = buf.getShort();
            }
            layer.setLocked(locked);
        }
        this.song.setLength((short)length);
        this.song.getTempoEvents().set(0, (float)this.song.getTempo() / 100.0f);
        for (NbsLayer layer : layers.values()) {
            for (Map.Entry<Integer, NbsNote> noteEntry : layer.getNotes().entrySet()) {
                NbsNote nbsNote = noteEntry.getValue();
                Note note = new Note();
                note.setNbsKey((float)NbsDefinitions.getEffectivePitch(nbsNote) / 100.0f);
                note.setVolume((float)layer.getVolume() / 100.0f * ((float)nbsNote.getVelocity() / 100.0f));
                if (layer.getPanning() == 100) {
                    note.setPanning((float)(nbsNote.getPanning() - 100) / 100.0f);
                } else {
                    note.setPanning((float)(layer.getPanning() - 100 + (nbsNote.getPanning() - 100)) / 200.0f);
                }
                if (nbsNote.getInstrument() < this.song.getVanillaInstrumentCount()) {
                    note.setInstrument(MinecraftInstrument.fromNbsId((byte)nbsNote.getInstrument()));
                }
                this.song.getNotes().add((int)noteEntry.getKey(), note);
            }
        }
    }

    public static int calculateMessageSize(NbsSong song) {
        int size = 15;
        for (NbsLayer layer : song.getLayers().values()) {
            size += LegacyNBSPacket.getLayerMessageSize(layer);
        }
        return size;
    }

    public static int getLayerMessageSize(NbsLayer layer) {
        return 4 + layer.getNotes().size() * 8;
    }
}

