/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.bukkit.network;

import io.github.kosmx.emotes.api.services.LoggerService;
import io.github.kosmx.emotes.bukkit.BukkitWrapper;
import io.github.kosmx.emotes.bukkit.network.BukkitNetworkInstance;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public final class ServerSideEmotePlay
extends AbstractServerEmotePlay<BukkitNetworkInstance>
implements Listener {
    private static final BukkitWrapper PLUGIN = (BukkitWrapper)BukkitWrapper.getPlugin(BukkitWrapper.class);
    private final HashMap<UUID, BukkitNetworkInstance> players = new HashMap();

    public void receivePluginMessage(String channel, Player player, byte[] message) {
        if (channel.equals(BukkitWrapper.EMOTE_PACKET)) {
            BukkitNetworkInstance playerNetwork = this.players.get(player.getUniqueId());
            if (playerNetwork != null) {
                try {
                    this.receiveMessage(message, playerNetwork);
                }
                catch (Exception e) {
                    LoggerService.INSTANCE.log(Level.WARNING, e.getMessage(), e);
                }
            } else {
                LoggerService.INSTANCE.log(Level.WARNING, "Player: " + player.getName() + " is not registered");
            }
        }
    }

    @Override
    public UUID getUUIDFromPlayer(BukkitNetworkInstance player) {
        return player.player.getUniqueId();
    }

    public BukkitNetworkInstance getPlayerNetworkInstance(Player player) {
        return this.getPlayerFromUUID(player.getUniqueId());
    }

    @Override
    public BukkitNetworkInstance getPlayerFromUUID(UUID playerUuid) {
        if (!this.players.containsKey(playerUuid)) {
            Player player = PLUGIN.getServer().getPlayer(playerUuid);
            if (player == null) {
                return null;
            }
            LoggerService.INSTANCE.log(Level.INFO, "Player " + player.getName() + " never joined. If it is a fake player, the fake-player plugin forgot to fire join event.");
            this.players.put(playerUuid, new BukkitNetworkInstance(player));
        }
        return this.players.get(playerUuid);
    }

    @Override
    protected void sendForEveryoneElse(NetData data, BukkitNetworkInstance player) {
        for (Player player1 : player.player.getTrackedBy()) {
            BukkitNetworkInstance instance = this.getPlayerNetworkInstance(player1);
            if (instance == player || !player1.getListeningPluginChannels().contains(BukkitWrapper.EMOTE_PACKET)) continue;
            this.sendForPlayer(data, player, instance);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.players.put(event.getPlayer().getUniqueId(), new BukkitNetworkInstance(event.getPlayer()));
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        BukkitNetworkInstance instance = this.players.remove(event.getPlayer().getUniqueId());
        if (instance != null) {
            instance.closeConnection();
        }
    }

    @EventHandler
    public void onPlayerTrackEntity(PlayerTrackEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.playerStartTracking(this.getPlayerNetworkInstance(player), this.getPlayerNetworkInstance(event.getPlayer()));
        }
    }

    public static ServerSideEmotePlay getInstance() {
        return (ServerSideEmotePlay)AbstractServerEmotePlay.getInstance();
    }
}

