/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.bukkit;

import io.github.kosmx.emotes.api.services.LoggerService;
import io.github.kosmx.emotes.bukkit.fuckery.StreamCodecUtils;
import io.github.kosmx.emotes.bukkit.network.ServerSideEmotePlay;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.mc.ServerCommands;
import io.github.kosmx.emotes.server.config.ConfigSerializer;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.logging.Level;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.resources.ResourceLocation;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitWrapper
extends JavaPlugin {
    public static final String EMOTE_PACKET = CommonData.getIDAsString("emote");

    public void onLoad() {
        if (CommonData.isLoaded) {
            this.getLogger().warning("Emotecraft is loaded multiple times, please load it only once!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        CommonData.isLoaded = true;
        try {
            StreamCodecUtils.replaceFallback(StreamCodecUtils.getThis(ServerboundCustomPayloadPacket.STREAM_CODEC), id -> DiscardedPayload.codec((ResourceLocation)id, (int)0x100000));
        }
        catch (ReflectiveOperationException e) {
            LoggerService.INSTANCE.log(Level.SEVERE, "Failed to hack size! Try update your paper!", e);
            this.getServer().shutdown();
        }
        Serializer.INSTANCE = new Serializer<SerializableConfig>(new ConfigSerializer<SerializableConfig>(SerializableConfig::new), SerializableConfig.class);
        UniversalEmoteSerializer.loadEmotes();
        for (String permission : ServerCommands.PERMISSIONS) {
            Bukkit.getPluginManager().addPermission(new Permission(permission));
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> ServerCommands.register(((Commands)event.registrar()).getDispatcher(), true));
    }

    public void onEnable() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, EMOTE_PACKET);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, EMOTE_PACKET, ServerSideEmotePlay.getInstance()::receivePluginMessage);
        this.getServer().getPluginManager().registerEvents((Listener)ServerSideEmotePlay.getInstance(), (Plugin)this);
        this.getLogger().info("Loading Emotecraft as a bukkit plugin...");
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this, EMOTE_PACKET);
    }
}

